/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import io.camunda.zeebe.gateway.admin.backup.BackupApi;
import io.camunda.zeebe.gateway.admin.backup.BackupRequestHandler;
import io.camunda.zeebe.gateway.admin.backup.BackupStatus;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import java.util.concurrent.CompletionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@WebEndpoint(id="backups", enableByDefault=false)
final class BackupEndpoint {
    private final BackupApi api;

    @Autowired
    public BackupEndpoint(BrokerClient client) {
        this((BackupApi)new BackupRequestHandler(client));
    }

    BackupEndpoint(BackupApi api) {
        this.api = api;
    }

    @WriteOperation
    public WebEndpointResponse<?> take(@Selector @NonNull long id) {
        try {
            long backupId = (Long)this.api.takeBackup(id).toCompletableFuture().join();
            return new WebEndpointResponse((Object)new TakeBackupResponse(backupId));
        }
        catch (CompletionException e) {
            return new WebEndpointResponse((Object)new ErrorResponse(id, e.getCause().getMessage()), 500);
        }
        catch (Exception e) {
            return new WebEndpointResponse((Object)new ErrorResponse(id, e.getMessage()), 500);
        }
    }

    @ReadOperation
    public WebEndpointResponse<?> status(@Selector @NonNull long id) {
        try {
            BackupStatus status = (BackupStatus)this.api.getStatus(id).toCompletableFuture().join();
            return new WebEndpointResponse((Object)status);
        }
        catch (CompletionException e) {
            return new WebEndpointResponse((Object)new ErrorResponse(id, e.getCause().getMessage()), 500);
        }
        catch (Exception e) {
            return new WebEndpointResponse((Object)new ErrorResponse(id, e.getMessage()), 500);
        }
    }

    record TakeBackupResponse(long id) {
    }

    record ErrorResponse(long id, String failure) {
    }
}

