/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.api;

import io.camunda.zeebe.engine.api.Task;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import java.time.Duration;
import java.util.function.BiConsumer;

public interface ProcessingScheduleService {
    public void runDelayed(Duration var1, Runnable var2);

    public void runDelayed(Duration var1, Task var2);

    public <T> void runOnCompletion(ActorFuture<T> var1, BiConsumer<T, Throwable> var2);

    default public void runAtFixedRate(Duration delay, Runnable task) {
        this.runDelayed(delay, () -> {
            try {
                task.run();
            }
            finally {
                this.runAtFixedRate(delay, task);
            }
        });
    }

    public void runAtFixedRate(Duration var1, Task var2);
}

