/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.util.Either;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class BpmnEventPublicationBehavior {
    private final ElementInstanceState elementInstanceState;
    private final EventHandle eventHandle;
    private final CatchEventAnalyzer catchEventAnalyzer;

    public BpmnEventPublicationBehavior(ZeebeState zeebeState, KeyGenerator keyGenerator, EventTriggerBehavior eventTriggerBehavior, Writers writers) {
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.eventHandle = new EventHandle(keyGenerator, zeebeState.getEventScopeInstanceState(), writers, zeebeState.getProcessState(), eventTriggerBehavior);
        this.catchEventAnalyzer = new CatchEventAnalyzer(zeebeState.getProcessState(), this.elementInstanceState);
    }

    public void throwErrorEvent(CatchEventAnalyzer.CatchEventTuple catchEventTuple) {
        ExecutableCatchEvent catchEvent;
        ElementInstance eventScopeInstance = catchEventTuple.getElementInstance();
        if (this.eventHandle.canTriggerElement(eventScopeInstance, (catchEvent = catchEventTuple.getCatchEvent()).getId())) {
            this.eventHandle.activateElement(catchEvent, eventScopeInstance.getKey(), eventScopeInstance.getValue());
        }
    }

    public Either<Failure, CatchEventAnalyzer.CatchEventTuple> findErrorCatchEvent(DirectBuffer errorCode, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(context.getFlowScopeKey());
        return this.catchEventAnalyzer.findCatchEvent(errorCode, flowScopeInstance, Optional.empty());
    }
}

