/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class BpmnVariableMappingBehavior {
    private final ExpressionProcessor expressionProcessor;
    private final VariableState variablesState;
    private final ElementInstanceState elementInstanceState;
    private final VariableBehavior variableBehavior;
    private final EventScopeInstanceState eventScopeInstanceState;

    public BpmnVariableMappingBehavior(ExpressionProcessor expressionProcessor, ZeebeState zeebeState, VariableBehavior variableBehavior) {
        this.expressionProcessor = expressionProcessor;
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.variablesState = zeebeState.getVariableState();
        this.variableBehavior = variableBehavior;
        this.eventScopeInstanceState = zeebeState.getEventScopeInstanceState();
    }

    public Either<Failure, Void> applyInputMappings(BpmnElementContext context, ExecutableFlowNode element) {
        long scopeKey = context.getElementInstanceKey();
        long processDefinitionKey = context.getProcessDefinitionKey();
        long processInstanceKey = context.getProcessInstanceKey();
        DirectBuffer bpmnProcessId = context.getBpmnProcessId();
        Optional<Expression> inputMappingExpression = element.getInputMappings();
        if (inputMappingExpression.isPresent()) {
            return this.expressionProcessor.evaluateVariableMappingExpression(inputMappingExpression.get(), scopeKey).map(result -> {
                this.variableBehavior.mergeLocalDocument(scopeKey, processDefinitionKey, processInstanceKey, bpmnProcessId, (DirectBuffer)result);
                return null;
            });
        }
        return Either.right(null);
    }

    public Either<Failure, Void> applyOutputMappings(BpmnElementContext context, ExecutableFlowNode element) {
        ProcessInstanceRecord record = context.getRecordValue();
        long elementInstanceKey = context.getElementInstanceKey();
        long processDefinitionKey = record.getProcessDefinitionKey();
        long processInstanceKey = record.getProcessInstanceKey();
        DirectBuffer bpmnProcessId = context.getBpmnProcessId();
        long scopeKey = this.getVariableScopeKey(context);
        Optional<Expression> outputMappingExpression = element.getOutputMappings();
        EventTrigger eventTrigger = this.eventScopeInstanceState.peekEventTrigger(elementInstanceKey);
        boolean hasVariables = false;
        DirectBuffer variables = null;
        if (eventTrigger != null) {
            variables = eventTrigger.getVariables();
            boolean bl = hasVariables = variables.capacity() > 0;
        }
        if (outputMappingExpression.isPresent()) {
            if (hasVariables) {
                this.variableBehavior.mergeLocalDocument(elementInstanceKey, processDefinitionKey, processInstanceKey, bpmnProcessId, variables);
            }
            return this.expressionProcessor.evaluateVariableMappingExpression(outputMappingExpression.get(), elementInstanceKey).map(result -> {
                this.variableBehavior.mergeDocument(scopeKey, processDefinitionKey, processInstanceKey, bpmnProcessId, (DirectBuffer)result);
                return null;
            });
        }
        if (hasVariables) {
            this.variableBehavior.mergeDocument(elementInstanceKey, processDefinitionKey, processInstanceKey, bpmnProcessId, variables);
        } else if (this.isConnectedToEventBasedGateway(element) || element.getElementType() == BpmnElementType.BOUNDARY_EVENT || element.getElementType() == BpmnElementType.START_EVENT) {
            DirectBuffer localVariables = this.variablesState.getVariablesLocalAsDocument(elementInstanceKey);
            this.variableBehavior.mergeDocument(scopeKey, processDefinitionKey, processInstanceKey, bpmnProcessId, localVariables);
        }
        return Either.right(null);
    }

    private long getVariableScopeKey(BpmnElementContext context) {
        long elementInstanceKey = context.getElementInstanceKey();
        boolean isMultiInstanceActivity = this.elementInstanceState.getInstance(elementInstanceKey).getMultiInstanceLoopCounter() > 0;
        return isMultiInstanceActivity ? elementInstanceKey : context.getFlowScopeKey();
    }

    private boolean isConnectedToEventBasedGateway(ExecutableFlowNode element) {
        if (element instanceof ExecutableCatchEventElement) {
            ExecutableCatchEventElement catchEvent = (ExecutableCatchEventElement)element;
            return catchEvent.isConnectedToEventBasedGateway();
        }
        return false;
    }
}

