/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.function.Consumer;

public interface CommandProcessor<T extends UnifiedRecordValue> {
    default public boolean onCommand(TypedRecord<T> command, CommandControl<T> commandControl) {
        return true;
    }

    default public boolean onCommand(TypedRecord<T> command, CommandControl<T> commandControl, Consumer<SideEffectProducer> sideEffect) {
        return this.onCommand(command, commandControl);
    }

    default public void afterAccept(TypedCommandWriter commandWriter, StateWriter stateWriter, long key, Intent intent, T value) {
    }

    default public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<T> command, Throwable error) {
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    public static interface CommandControl<T> {
        public long accept(Intent var1, T var2);

        public void reject(RejectionType var1, String var2);
    }
}

