/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.api.TaskResultBuilder;
import io.camunda.zeebe.engine.processing.scheduled.DueDateChecker;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.util.FeatureFlags;
import java.time.Duration;
import java.util.function.Function;

public class DueDateTimerChecker
implements StreamProcessorLifecycleAware {
    private static final long TIMER_RESOLUTION = Duration.ofMillis(100L).toMillis();
    private static final double GIVE_YIELD_FACTOR = 0.5;
    private final DueDateChecker dueDateChecker;

    public DueDateTimerChecker(TimerInstanceState timerInstanceState, FeatureFlags featureFlags) {
        this.dueDateChecker = new DueDateChecker(TIMER_RESOLUTION, new TriggerTimersSideEffect(timerInstanceState, ActorClock.current(), featureFlags.yieldingDueDateChecker()));
    }

    public void scheduleTimer(long dueDate) {
        this.dueDateChecker.schedule(dueDate);
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext context) {
        this.dueDateChecker.onRecovered(context);
    }

    @Override
    public void onClose() {
        this.dueDateChecker.onClose();
    }

    @Override
    public void onFailed() {
        this.dueDateChecker.onFailed();
    }

    @Override
    public void onPaused() {
        this.dueDateChecker.onPaused();
    }

    @Override
    public void onResumed() {
        this.dueDateChecker.onResumed();
    }

    protected static final class TriggerTimersSideEffect
    implements Function<TaskResultBuilder, Long> {
        private final ActorClock actorClock;
        private final TimerInstanceState timerInstanceState;
        private final boolean yieldControl;

        public TriggerTimersSideEffect(TimerInstanceState timerInstanceState, ActorClock actorClock, boolean yieldControl) {
            this.timerInstanceState = timerInstanceState;
            this.actorClock = actorClock;
            this.yieldControl = yieldControl;
        }

        @Override
        public Long apply(TaskResultBuilder taskResultBuilder) {
            long now = this.actorClock.getTimeMillis();
            long yieldAfter = now + Math.round((double)TIMER_RESOLUTION * 0.5);
            TimerInstanceState.TimerVisitor timerVisitor = this.yieldControl ? new YieldingDecorator(this.actorClock, yieldAfter, new WriteTriggerTimerCommandVisitor(taskResultBuilder)) : new WriteTriggerTimerCommandVisitor(taskResultBuilder);
            return this.timerInstanceState.processTimersWithDueDateBefore(now, timerVisitor);
        }
    }

    protected static final class YieldingDecorator
    implements TimerInstanceState.TimerVisitor {
        private final TimerInstanceState.TimerVisitor delegate;
        private final ActorClock actorClock;
        private final long giveYieldAfter;

        public YieldingDecorator(ActorClock actorClock, long giveYieldAfter, TimerInstanceState.TimerVisitor delegate) {
            this.delegate = delegate;
            this.actorClock = actorClock;
            this.giveYieldAfter = giveYieldAfter;
        }

        @Override
        public boolean visit(TimerInstance timer) {
            if (this.actorClock.getTimeMillis() >= this.giveYieldAfter) {
                return false;
            }
            return this.delegate.visit(timer);
        }
    }

    protected static final class WriteTriggerTimerCommandVisitor
    implements TimerInstanceState.TimerVisitor {
        private final TimerRecord timerRecord = new TimerRecord();
        private final TaskResultBuilder taskResultBuilder;

        public WriteTriggerTimerCommandVisitor(TaskResultBuilder taskResultBuilder) {
            this.taskResultBuilder = taskResultBuilder;
        }

        @Override
        public boolean visit(TimerInstance timer) {
            this.timerRecord.reset();
            this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setProcessInstanceKey(timer.getProcessInstanceKey()).setDueDate(timer.getDueDate()).setTargetElementId(timer.getHandlerNodeId()).setRepetitions(timer.getRepetitions()).setProcessDefinitionKey(timer.getProcessDefinitionKey());
            return this.taskResultBuilder.appendCommandRecord(timer.getKey(), (Intent)TimerIntent.TRIGGER, (UnifiedRecordValue)this.timerRecord);
        }
    }
}

