/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.api.PostCommitTask;
import io.camunda.zeebe.engine.api.ProcessingResponse;
import io.camunda.zeebe.engine.api.ProcessingResult;
import io.camunda.zeebe.engine.api.ProcessingResultBuilder;
import io.camunda.zeebe.engine.api.records.RecordBatch;
import io.camunda.zeebe.engine.api.records.RecordBatchEntry;
import io.camunda.zeebe.engine.api.records.RecordBatchSizePredicate;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedEventRegistry;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.streamprocessor.BufferedResult;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.List;

final class BufferedProcessingResultBuilder
implements ProcessingResultBuilder {
    private final List<PostCommitTask> postCommitTasks = new ArrayList<PostCommitTask>();
    private final RecordBatch mutableRecordBatch;
    private ProcessingResponseImpl processingResponse;

    BufferedProcessingResultBuilder(RecordBatchSizePredicate predicate) {
        this.mutableRecordBatch = new RecordBatch(predicate);
    }

    @Override
    public Either<RuntimeException, ProcessingResultBuilder> appendRecordReturnEither(long key, RecordType type, Intent intent, RejectionType rejectionType, String rejectionReason, RecordValue value) {
        ValueType valueType = TypedEventRegistry.TYPE_REGISTRY.get(value.getClass());
        if (valueType == null) {
            throw new IllegalStateException("Missing value type mapping for record: " + value.getClass());
        }
        if (value instanceof UnifiedRecordValue) {
            UnifiedRecordValue unifiedRecordValue = (UnifiedRecordValue)value;
            Either<RuntimeException, Void> either = this.mutableRecordBatch.appendRecord(key, -1, type, intent, rejectionType, rejectionReason, valueType, (BufferWriter)unifiedRecordValue);
            if (either.isLeft()) {
                return Either.left((Object)((RuntimeException)either.getLeft()));
            }
        } else {
            throw new IllegalStateException(String.format("The record value %s is not a UnifiedRecordValue", StringUtil.limitString((String)value.toString(), (int)1024)));
        }
        return Either.right((Object)this);
    }

    @Override
    public ProcessingResultBuilder withResponse(RecordType recordType, long key, Intent intent, UnpackedObject value, ValueType valueType, RejectionType rejectionType, String rejectionReason, long requestId, int requestStreamId) {
        RecordBatchEntry entry = RecordBatchEntry.createEntry(key, -1, recordType, intent, rejectionType, rejectionReason, valueType, (BufferWriter)value);
        this.processingResponse = new ProcessingResponseImpl(entry, requestId, requestStreamId);
        return this;
    }

    @Override
    public ProcessingResultBuilder appendPostCommitTask(PostCommitTask task) {
        this.postCommitTasks.add(task);
        return this;
    }

    @Override
    public ProcessingResultBuilder resetPostCommitTasks() {
        this.postCommitTasks.clear();
        return this;
    }

    @Override
    public ProcessingResult build() {
        return new BufferedResult(this.mutableRecordBatch, this.processingResponse, this.postCommitTasks);
    }

    @Override
    public boolean canWriteEventOfLength(int eventLength) {
        return this.mutableRecordBatch.canAppendRecordOfLength(eventLength);
    }

    record ProcessingResponseImpl(RecordBatchEntry responseValue, long requestId, int requestStreamId) implements ProcessingResponse
    {
    }
}

