/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.api.RecordProcessor;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.metrics.StreamProcessorMetrics;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordValues;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.state.processing.DbKeyGenerator;
import io.camunda.zeebe.logstreams.impl.Loggers;
import io.camunda.zeebe.logstreams.log.LogRecordAwaiter;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBatchWriter;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.streamprocessor.LastProcessingPositions;
import io.camunda.zeebe.streamprocessor.ProcessingScheduleServiceImpl;
import io.camunda.zeebe.streamprocessor.ProcessingStateMachine;
import io.camunda.zeebe.streamprocessor.RecordProcessorContextImpl;
import io.camunda.zeebe.streamprocessor.ReplayStateMachine;
import io.camunda.zeebe.streamprocessor.StreamProcessorBuilder;
import io.camunda.zeebe.streamprocessor.StreamProcessorContext;
import io.camunda.zeebe.streamprocessor.StreamProcessorMode;
import io.camunda.zeebe.streamprocessor.state.StreamProcessorDbState;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthReport;
import io.prometheus.client.Gauge;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;

public class StreamProcessor
extends Actor
implements HealthMonitorable,
LogRecordAwaiter {
    public static final long UNSET_POSITION = -1L;
    public static final Duration HEALTH_CHECK_TICK_DURATION = Duration.ofSeconds(5L);
    private static final String ERROR_MESSAGE_RECOVER_FROM_SNAPSHOT_FAILED = "Expected to find event with the snapshot position %s in log stream, but nothing was found. Failed to recover '%s'.";
    private static final Logger LOG = Loggers.LOGSTREAMS_LOGGER;
    private final ActorSchedulingService actorSchedulingService;
    private final AtomicBoolean isOpened = new AtomicBoolean(false);
    private final List<StreamProcessorLifecycleAware> lifecycleAwareListeners;
    private final Function<MutableZeebeState, EventApplier> eventApplierFactory;
    private final Set<FailureListener> failureListeners = new HashSet<FailureListener>();
    private final StreamProcessorMetrics metrics;
    private final LogStream logStream;
    private final int partitionId;
    private final ZeebeDb zeebeDb;
    private final StreamProcessorContext streamProcessorContext;
    private final String actorName;
    private LogStreamReader logStreamReader;
    private ProcessingStateMachine processingStateMachine;
    private ReplayStateMachine replayStateMachine;
    private CompletableActorFuture<Void> openFuture;
    private final CompletableActorFuture<Void> closeFuture = new CompletableActorFuture();
    private volatile long lastTickTime;
    private boolean shouldProcess = true;
    private ActorFuture<LastProcessingPositions> replayCompletedFuture;
    private final List<RecordProcessor> recordProcessors = new ArrayList<RecordProcessor>();
    private StreamProcessorDbState streamProcessorDbState;
    private ProcessingScheduleServiceImpl scheduleService;

    protected StreamProcessor(StreamProcessorBuilder processorBuilder) {
        this.actorSchedulingService = processorBuilder.getActorSchedulingService();
        this.lifecycleAwareListeners = processorBuilder.getLifecycleListeners();
        this.zeebeDb = processorBuilder.getZeebeDb();
        this.eventApplierFactory = processorBuilder.getEventApplierFactory();
        this.streamProcessorContext = processorBuilder.getProcessingContext().eventCache(new RecordValues()).actor(this.actor).abortCondition(this::isClosed);
        this.logStream = this.streamProcessorContext.getLogStream();
        this.partitionId = this.logStream.getPartitionId();
        this.actorName = StreamProcessor.buildActorName((int)processorBuilder.getNodeId(), (String)"StreamProcessor", (int)this.partitionId);
        this.metrics = new StreamProcessorMetrics(this.partitionId);
        this.recordProcessors.addAll(processorBuilder.getRecordProcessors());
    }

    public static StreamProcessorBuilder builder() {
        return new StreamProcessorBuilder();
    }

    @Deprecated
    public StreamProcessorDbState getStreamProcessorDbState() {
        return this.streamProcessorDbState;
    }

    protected Map<String, String> createContext() {
        Map context = super.createContext();
        context.put("partitionId", Integer.toString(this.partitionId));
        return context;
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarting() {
        this.actor.runOnCompletionBlockingCurrentPhase(this.logStream.newLogStreamReader(), this::onRetrievingReader);
    }

    protected void onActorStarted() {
        try {
            LOG.debug("Recovering state of partition {} from snapshot", (Object)this.partitionId);
            Gauge.Timer startRecoveryTimer = this.metrics.startRecoveryTimer();
            long snapshotPosition = this.recoverFromSnapshot();
            this.scheduleService = new ProcessingScheduleServiceImpl(this.streamProcessorContext::getStreamProcessorPhase, this.streamProcessorContext.getAbortCondition(), () -> ((LogStream)this.logStream).newLogStreamBatchWriter());
            this.streamProcessorContext.scheduleService(this.scheduleService);
            this.initRecordProcessors();
            this.healthCheckTick();
            this.replayStateMachine = new ReplayStateMachine(this.recordProcessors, this.streamProcessorContext, this::shouldProcessNext);
            this.openFuture.complete(null);
            this.replayCompletedFuture = this.replayStateMachine.startRecover(snapshotPosition);
            if (!this.shouldProcess) {
                this.setStateToPausedAndNotifyListeners();
            } else {
                this.streamProcessorContext.streamProcessorPhase(Phase.REPLAY);
            }
            if (this.isInReplayOnlyMode()) {
                this.replayCompletedFuture.onComplete((v, error) -> {
                    if (error != null) {
                        LOG.error("The replay of events failed.", error);
                        this.onFailure((Throwable)error);
                    }
                });
            } else {
                this.replayCompletedFuture.onComplete((lastProcessingPositions, error) -> {
                    if (error != null) {
                        LOG.error("The replay of events failed.", error);
                        this.onFailure((Throwable)error);
                    } else {
                        this.onRecovered((LastProcessingPositions)lastProcessingPositions);
                        startRecoveryTimer.close();
                    }
                });
            }
        }
        catch (RuntimeException e) {
            this.onFailure(e);
        }
    }

    protected void onActorClosing() {
        this.tearDown();
    }

    protected void onActorClosed() {
        this.closeFuture.complete(null);
        LOG.debug("Closed stream processor controller {}.", (Object)this.getName());
    }

    protected void onActorCloseRequested() {
        if (!this.isFailed()) {
            this.lifecycleAwareListeners.forEach(StreamProcessorLifecycleAware::onClose);
        }
    }

    public ActorFuture<Void> closeAsync() {
        this.isOpened.set(false);
        this.actor.close();
        return this.closeFuture;
    }

    protected void handleFailure(Throwable failure) {
        this.onFailure(failure);
    }

    public void onActorFailed() {
        this.streamProcessorContext.streamProcessorPhase(Phase.FAILED);
        this.isOpened.set(false);
        this.lifecycleAwareListeners.forEach(StreamProcessorLifecycleAware::onFailed);
        this.tearDown();
        this.closeFuture.complete(null);
    }

    private boolean shouldProcessNext() {
        return this.isOpened() && this.shouldProcess;
    }

    private void tearDown() {
        this.scheduleService.close();
        this.streamProcessorContext.getLogStreamReader().close();
        this.logStream.removeRecordAvailableListener((LogRecordAwaiter)this);
        this.replayStateMachine.close();
    }

    private void healthCheckTick() {
        this.lastTickTime = ActorClock.currentTimeMillis();
        this.actor.runDelayed(HEALTH_CHECK_TICK_DURATION, this::healthCheckTick);
    }

    private void onRetrievingWriter(LogStreamBatchWriter batchWriter, Throwable errorOnReceivingWriter, LastProcessingPositions lastProcessingPositions) {
        if (errorOnReceivingWriter == null) {
            this.streamProcessorContext.logStreamBatchWriter(batchWriter);
            this.streamProcessorContext.streamProcessorPhase(Phase.PROCESSING);
            ActorFuture<Void> scheduleServiceOpenFuture = this.scheduleService.open(this.actor);
            scheduleServiceOpenFuture.onComplete((v, failure) -> {
                if (failure == null) {
                    this.startProcessing(lastProcessingPositions);
                } else {
                    this.onFailure((Throwable)failure);
                }
            });
        } else {
            this.onFailure(errorOnReceivingWriter);
        }
    }

    private void startProcessing(LastProcessingPositions lastProcessingPositions) {
        this.processingStateMachine = new ProcessingStateMachine(this.streamProcessorContext, this::shouldProcessNext, this.recordProcessors);
        this.logStream.registerRecordAvailableListener((LogRecordAwaiter)this);
        this.lifecycleAwareListeners.forEach(l -> l.onRecovered(this.streamProcessorContext));
        this.processingStateMachine.startProcessing(lastProcessingPositions);
        if (!this.shouldProcess) {
            this.setStateToPausedAndNotifyListeners();
        }
    }

    private void onRetrievingReader(LogStreamReader reader, Throwable errorOnReceivingReader) {
        if (errorOnReceivingReader == null) {
            this.logStreamReader = reader;
            this.streamProcessorContext.logStreamReader(reader);
        } else {
            LOG.error("Unexpected error on retrieving reader from log stream.", errorOnReceivingReader);
            this.actor.close();
        }
    }

    public ActorFuture<Void> openAsync(boolean pauseOnStart) {
        if (this.isOpened.compareAndSet(false, true)) {
            this.shouldProcess = !pauseOnStart;
            this.openFuture = new CompletableActorFuture();
            this.actorSchedulingService.submitActor((Actor)this);
        }
        return this.openFuture;
    }

    private void initRecordProcessors() {
        RecordProcessorContextImpl processorContext = new RecordProcessorContextImpl(this.partitionId, this.streamProcessorContext.getScheduleService(), this.zeebeDb, this.streamProcessorContext.getTransactionContext(), this.eventApplierFactory, this.streamProcessorContext.getPartitionCommandSender(), this.streamProcessorContext.getKeyGeneratorControls());
        this.recordProcessors.forEach(processor -> processor.init(processorContext));
        this.lifecycleAwareListeners.addAll(processorContext.getLifecycleListeners());
    }

    private long recoverFromSnapshot() {
        boolean failedToRecoverReader;
        TransactionContext transactionContext = this.zeebeDb.createContext();
        this.streamProcessorContext.transactionContext(transactionContext);
        this.streamProcessorContext.keyGeneratorControls(new DbKeyGenerator(this.partitionId, this.zeebeDb, transactionContext));
        this.streamProcessorDbState = new StreamProcessorDbState(this.zeebeDb, transactionContext);
        this.streamProcessorContext.lastProcessedPositionState(this.streamProcessorDbState.getLastProcessedPositionState());
        long snapshotPosition = this.streamProcessorDbState.getLastProcessedPositionState().getLastSuccessfulProcessedRecordPosition();
        boolean bl = failedToRecoverReader = !this.logStreamReader.seekToNextEvent(snapshotPosition);
        if (failedToRecoverReader && this.streamProcessorContext.getProcessorMode() == StreamProcessorMode.PROCESSING) {
            throw new IllegalStateException(String.format(ERROR_MESSAGE_RECOVER_FROM_SNAPSHOT_FAILED, snapshotPosition, this.getName()));
        }
        LOG.info("Recovered state of partition {} from snapshot at position {}", (Object)this.partitionId, (Object)snapshotPosition);
        return snapshotPosition;
    }

    private void onRecovered(LastProcessingPositions lastProcessingPositions) {
        this.logStream.newLogStreamBatchWriter().onComplete((batchWriter, errorOnReceivingWriter) -> this.onRetrievingWriter((LogStreamBatchWriter)batchWriter, (Throwable)errorOnReceivingWriter, lastProcessingPositions));
    }

    private void onFailure(Throwable throwable) {
        LOG.error("Actor {} failed in phase {}.", new Object[]{this.actorName, this.actor.getLifecyclePhase(), throwable});
        this.actor.fail(throwable);
        if (!this.openFuture.isDone()) {
            this.openFuture.completeExceptionally(throwable);
        }
        if (throwable instanceof UnrecoverableException) {
            HealthReport report = HealthReport.dead((HealthMonitorable)this).withIssue(throwable);
            this.failureListeners.forEach(l -> l.onUnrecoverableFailure(report));
        } else {
            HealthReport report = HealthReport.unhealthy((HealthMonitorable)this).withIssue(throwable);
            this.failureListeners.forEach(l -> l.onFailure(report));
        }
    }

    public boolean isOpened() {
        return this.isOpened.get();
    }

    public boolean isClosed() {
        return !this.isOpened.get();
    }

    public boolean isFailed() {
        return this.streamProcessorContext.getStreamProcessorPhase() == Phase.FAILED;
    }

    public ActorFuture<Long> getLastProcessedPositionAsync() {
        return this.actor.call(() -> {
            if (this.isInReplayOnlyMode()) {
                return this.replayStateMachine.getLastSourceEventPosition();
            }
            if (this.processingStateMachine == null) {
                return -1L;
            }
            return this.processingStateMachine.getLastSuccessfulProcessedRecordPosition();
        });
    }

    private boolean isInReplayOnlyMode() {
        return this.streamProcessorContext.getProcessorMode() == StreamProcessorMode.REPLAY;
    }

    public ActorFuture<Long> getLastWrittenPositionAsync() {
        return this.actor.call(() -> {
            if (this.isInReplayOnlyMode()) {
                return this.replayStateMachine.getLastReplayedEventPosition();
            }
            if (this.processingStateMachine == null) {
                return -1L;
            }
            return this.processingStateMachine.getLastWrittenPosition();
        });
    }

    public HealthReport getHealthReport() {
        if (this.actor.isClosed()) {
            return HealthReport.unhealthy((HealthMonitorable)this).withMessage("actor is closed");
        }
        if (this.processingStateMachine != null && !this.processingStateMachine.isMakingProgress()) {
            return HealthReport.unhealthy((HealthMonitorable)this).withMessage("not making progress");
        }
        if (ActorClock.currentTimeMillis() - this.lastTickTime > HEALTH_CHECK_TICK_DURATION.toMillis() * 2L) {
            return HealthReport.unhealthy((HealthMonitorable)this).withMessage("actor appears blocked");
        }
        if (this.streamProcessorContext.getStreamProcessorPhase() == Phase.FAILED) {
            return HealthReport.unhealthy((HealthMonitorable)this).withMessage("in failed phase");
        }
        return HealthReport.healthy((HealthMonitorable)this);
    }

    public void addFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.failureListeners.add(failureListener));
    }

    public void removeFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.failureListeners.remove(failureListener));
    }

    public ActorFuture<Phase> getCurrentPhase() {
        return this.actor.call(this.streamProcessorContext::getStreamProcessorPhase);
    }

    public ActorFuture<Void> pauseProcessing() {
        return this.actor.call(() -> {
            if (this.shouldProcess) {
                this.setStateToPausedAndNotifyListeners();
            }
        });
    }

    public ActorFuture<Boolean> hasProcessingReachedTheEnd() {
        return this.actor.call(() -> this.processingStateMachine != null && !this.isInReplayOnlyMode() && this.processingStateMachine.hasReachedEnd());
    }

    private void setStateToPausedAndNotifyListeners() {
        if (this.isInReplayOnlyMode() || !this.replayCompletedFuture.isDone()) {
            LOG.debug("Paused replay for partition {}", (Object)this.partitionId);
        } else {
            this.lifecycleAwareListeners.forEach(StreamProcessorLifecycleAware::onPaused);
            LOG.debug("Paused processing for partition {}", (Object)this.partitionId);
        }
        this.shouldProcess = false;
        this.streamProcessorContext.streamProcessorPhase(Phase.PAUSED);
    }

    public void resumeProcessing() {
        this.actor.call(() -> {
            if (!this.shouldProcess) {
                this.shouldProcess = true;
                if (this.isInReplayOnlyMode() || !this.replayCompletedFuture.isDone()) {
                    this.streamProcessorContext.streamProcessorPhase(Phase.REPLAY);
                    this.actor.submit(this.replayStateMachine::replayNextEvent);
                    LOG.debug("Resumed replay for partition {}", (Object)this.partitionId);
                } else {
                    this.lifecycleAwareListeners.forEach(StreamProcessorLifecycleAware::onResumed);
                    this.streamProcessorContext.streamProcessorPhase(Phase.PROCESSING);
                    if (this.processingStateMachine != null) {
                        this.actor.submit(this.processingStateMachine::readNextRecord);
                    }
                    LOG.debug("Resumed processing for partition {}", (Object)this.partitionId);
                }
            }
        });
    }

    public void onRecordAvailable() {
        this.actor.run(this.processingStateMachine::readNextRecord);
    }

    public static enum Phase {
        INITIAL,
        REPLAY,
        PROCESSING,
        FAILED,
        PAUSED;

    }
}

