/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.engine.api.CommandResponseWriter;
import io.camunda.zeebe.engine.api.InterPartitionCommandSender;
import io.camunda.zeebe.engine.api.ProcessingScheduleService;
import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordValues;
import io.camunda.zeebe.engine.state.KeyGeneratorControls;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBatchWriter;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.streamprocessor.StreamProcessor;
import io.camunda.zeebe.streamprocessor.StreamProcessorListener;
import io.camunda.zeebe.streamprocessor.StreamProcessorMode;
import io.camunda.zeebe.streamprocessor.state.MutableLastProcessedPositionState;
import java.util.function.BooleanSupplier;

public final class StreamProcessorContext
implements ReadonlyStreamProcessorContext {
    private static final StreamProcessorListener NOOP_LISTENER = new StreamProcessorListener(){

        @Override
        public void onProcessed(TypedRecord<?> processedCommand) {
        }

        @Override
        public void onSkipped(LoggedEvent skippedRecord) {
        }
    };
    private ActorControl actor;
    private LogStream logStream;
    private LogStreamReader logStreamReader;
    private RecordValues recordValues;
    private TransactionContext transactionContext;
    private BooleanSupplier abortCondition;
    private StreamProcessorListener streamProcessorListener = NOOP_LISTENER;
    private StreamProcessorMode streamProcessorMode = StreamProcessorMode.PROCESSING;
    private ProcessingScheduleService processingScheduleService;
    private MutableLastProcessedPositionState lastProcessedPositionState;
    private LogStreamBatchWriter logStreamBatchWriter;
    private CommandResponseWriter commandResponseWriter;
    private InterPartitionCommandSender partitionCommandSender;
    private volatile StreamProcessor.Phase phase = StreamProcessor.Phase.INITIAL;
    private KeyGeneratorControls keyGeneratorControls;

    public StreamProcessorContext actor(ActorControl actor) {
        this.actor = actor;
        return this;
    }

    public StreamProcessorContext scheduleService(ProcessingScheduleService scheduleService) {
        this.processingScheduleService = scheduleService;
        return this;
    }

    @Override
    public ProcessingScheduleService getScheduleService() {
        return this.processingScheduleService;
    }

    @Override
    public int getPartitionId() {
        return this.getLogStream().getPartitionId();
    }

    public LogStream getLogStream() {
        return this.logStream;
    }

    public MutableLastProcessedPositionState getLastProcessedPositionState() {
        return this.lastProcessedPositionState;
    }

    StreamProcessorContext listener(StreamProcessorListener streamProcessorListener) {
        this.streamProcessorListener = streamProcessorListener;
        return this;
    }

    public StreamProcessorContext logStream(LogStream logStream) {
        this.logStream = logStream;
        return this;
    }

    public StreamProcessorContext logStreamReader(LogStreamReader logStreamReader) {
        this.logStreamReader = logStreamReader;
        return this;
    }

    public StreamProcessorContext eventCache(RecordValues recordValues) {
        this.recordValues = recordValues;
        return this;
    }

    public StreamProcessorContext keyGeneratorControls(KeyGeneratorControls keyGeneratorControls) {
        this.keyGeneratorControls = keyGeneratorControls;
        return this;
    }

    public StreamProcessorContext lastProcessedPositionState(MutableLastProcessedPositionState lastProcessedPositionState) {
        this.lastProcessedPositionState = lastProcessedPositionState;
        return this;
    }

    public StreamProcessorContext transactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
        return this;
    }

    public StreamProcessorContext abortCondition(BooleanSupplier abortCondition) {
        this.abortCondition = abortCondition;
        return this;
    }

    public StreamProcessorContext commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.commandResponseWriter = commandResponseWriter;
        return this;
    }

    public StreamProcessorContext processorMode(StreamProcessorMode streamProcessorMode) {
        this.streamProcessorMode = streamProcessorMode;
        return this;
    }

    public KeyGeneratorControls getKeyGeneratorControls() {
        return this.keyGeneratorControls;
    }

    public ActorControl getActor() {
        return this.actor;
    }

    public LogStreamReader getLogStreamReader() {
        return this.logStreamReader;
    }

    public RecordValues getRecordValues() {
        return this.recordValues;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public BooleanSupplier getAbortCondition() {
        return this.abortCondition;
    }

    public StreamProcessorListener getStreamProcessorListener() {
        return this.streamProcessorListener;
    }

    public StreamProcessorMode getProcessorMode() {
        return this.streamProcessorMode;
    }

    public void logStreamBatchWriter(LogStreamBatchWriter batchWriter) {
        this.logStreamBatchWriter = batchWriter;
    }

    public LogStreamBatchWriter getLogStreamBatchWriter() {
        return this.logStreamBatchWriter;
    }

    public CommandResponseWriter getCommandResponseWriter() {
        return this.commandResponseWriter;
    }

    public InterPartitionCommandSender getPartitionCommandSender() {
        return this.partitionCommandSender;
    }

    public void partitionCommandSender(InterPartitionCommandSender partitionCommandSender) {
        this.partitionCommandSender = partitionCommandSender;
    }

    public StreamProcessor.Phase getStreamProcessorPhase() {
        return this.phase;
    }

    public void streamProcessorPhase(StreamProcessor.Phase phase) {
        this.phase = phase;
    }
}

