/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.exporter.ElasticsearchExporterException;
import io.camunda.zeebe.exporter.dto.BulkIndexAction;
import io.camunda.zeebe.protocol.record.Record;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.entity.ContentProducer;

final class BulkIndexRequest
implements ContentProducer {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    private final List<BulkOperation> operations = new ArrayList<BulkOperation>();
    private BulkIndexAction lastIndexedMetadata;
    private int memoryUsageBytes = 0;

    BulkIndexRequest() {
    }

    void index(BulkIndexAction action, Record<?> record) {
        byte[] source;
        if (this.lastIndexedMetadata != null && this.lastIndexedMetadata.equals(action)) {
            return;
        }
        try {
            source = MAPPER.writer().writeValueAsBytes(record);
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException(String.format("Failed to serialize record to JSON for indexing action %s", action), e);
        }
        BulkOperation command = new BulkOperation(action, source);
        this.memoryUsageBytes += command.source().length;
        this.lastIndexedMetadata = action;
        this.operations.add(command);
    }

    int size() {
        return this.operations.size();
    }

    int memoryUsageBytes() {
        return this.memoryUsageBytes;
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    void clear() {
        this.operations.clear();
        this.memoryUsageBytes = 0;
        this.lastIndexedMetadata = null;
    }

    BulkIndexAction lastIndexedMetadata() {
        return this.lastIndexedMetadata;
    }

    List<BulkOperation> bulkOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public void writeTo(OutputStream outStream) throws IOException {
        for (BulkOperation operation : this.operations) {
            MAPPER.writeValue(outStream, (Object)operation.metadata());
            outStream.write(10);
            outStream.write(operation.source());
            outStream.write(10);
        }
    }

    record BulkOperation(BulkIndexAction metadata, byte[] source) {
    }
}

