/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.query.impl;

import io.camunda.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteQueryRequest;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteQueryResponse;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class BrokerExecuteQuery
extends BrokerRequest<String> {
    private final ExecuteQueryRequest request = new ExecuteQueryRequest();
    private final ExecuteQueryResponse response = new ExecuteQueryResponse();

    public BrokerExecuteQuery() {
        super(0, 31);
    }

    public void setKey(long key) {
        this.request.setKey(key);
    }

    public void setValueType(ValueType valueType) {
        this.request.setValueType(valueType);
    }

    public int getPartitionId() {
        return this.request.getPartitionId();
    }

    @Override
    public void setPartitionId(int partitionId) {
        this.request.setPartitionId(partitionId);
    }

    @Override
    public boolean addressesSpecificPartition() {
        return true;
    }

    @Override
    public boolean requiresPartitionId() {
        return true;
    }

    @Override
    public BufferWriter getRequestWriter() {
        return null;
    }

    @Override
    protected void setSerializedValue(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void wrapResponse(DirectBuffer buffer) {
        this.response.wrap(buffer, 0, buffer.capacity());
    }

    @Override
    protected BrokerResponse<String> readResponse() {
        return new BrokerResponse<String>(this.response.getBpmnProcessId(), this.request.getPartitionId(), this.request.getKey());
    }

    @Override
    protected String toResponseDto(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return "Query#" + this.request.getValueType();
    }

    public RequestType getRequestType() {
        return RequestType.QUERY;
    }

    public int getLength() {
        return this.request.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.request.write(buffer, offset);
    }
}

