/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3.manifest;

import io.camunda.zeebe.backup.api.Backup;
import io.camunda.zeebe.backup.api.BackupDescriptor;
import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.backup.common.BackupDescriptorImpl;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.common.BackupStatusImpl;
import io.camunda.zeebe.backup.s3.manifest.FailedBackupManifest;
import io.camunda.zeebe.backup.s3.manifest.InProgressBackupManifest;
import io.camunda.zeebe.backup.s3.manifest.Manifest;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;

public final class NoBackupManifest
extends Record
implements Manifest {
    private final BackupIdentifierImpl id;

    public NoBackupManifest(BackupIdentifierImpl id) {
        this.id = id;
    }

    @Override
    public BackupStatusCode statusCode() {
        return BackupStatusCode.DOES_NOT_EXIST;
    }

    @Override
    public BackupStatus toStatus() {
        return new BackupStatusImpl((BackupIdentifier)this.id, Optional.empty(), this.statusCode(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Override
    public FailedBackupManifest asFailed(String failureReason) {
        Instant now = Instant.now();
        return new FailedBackupManifest(this.id, Optional.empty(), failureReason, Collections.emptySet(), Collections.emptySet(), now, now);
    }

    public InProgressBackupManifest asInProgress(Backup backup) {
        Instant now = Instant.now();
        return new InProgressBackupManifest(BackupIdentifierImpl.from((BackupIdentifier)backup.id()), BackupDescriptorImpl.from((BackupDescriptor)backup.descriptor()), backup.snapshot().names(), backup.segments().names(), now, now);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoBackupManifest.class, "id", "id"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoBackupManifest.class, "id", "id"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoBackupManifest.class, "id", "id"}, this, o);
    }

    public BackupIdentifierImpl id() {
        return this.id;
    }
}

