/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.RaftLog;
import io.atomix.utils.Builder;
import io.camunda.zeebe.journal.Journal;
import io.camunda.zeebe.journal.file.SegmentedJournal;
import io.camunda.zeebe.journal.file.SegmentedJournalBuilder;
import java.io.File;

public class RaftLogBuilder
implements Builder<RaftLog> {
    private final SegmentedJournalBuilder journalBuilder = SegmentedJournal.builder();
    private boolean flushExplicitly = true;

    protected RaftLogBuilder() {
    }

    public RaftLogBuilder withName(String name) {
        this.journalBuilder.withName(name);
        return this;
    }

    public RaftLogBuilder withDirectory(File directory) {
        this.journalBuilder.withDirectory(directory);
        return this;
    }

    public RaftLogBuilder withMaxSegmentSize(int maxSegmentSize) {
        this.journalBuilder.withMaxSegmentSize(maxSegmentSize);
        return this;
    }

    public RaftLogBuilder withFreeDiskSpace(long freeDiskSpace) {
        this.journalBuilder.withFreeDiskSpace(freeDiskSpace);
        return this;
    }

    public RaftLogBuilder withFlushExplicitly(boolean flushExplicitly) {
        this.flushExplicitly = flushExplicitly;
        return this;
    }

    public RaftLogBuilder withJournalIndexDensity(int journalIndexDensity) {
        this.journalBuilder.withJournalIndexDensity(journalIndexDensity);
        return this;
    }

    public RaftLogBuilder withLastWrittenIndex(long lastWrittenIndex) {
        this.journalBuilder.withLastWrittenIndex(lastWrittenIndex);
        return this;
    }

    public RaftLogBuilder withPreallocateSegmentFiles(boolean preallocateSegmentFiles) {
        this.journalBuilder.withPreallocateSegmentFiles(preallocateSegmentFiles);
        return this;
    }

    public RaftLog build() {
        SegmentedJournal journal = this.journalBuilder.build();
        return new RaftLog((Journal)journal, this.flushExplicitly);
    }
}

