/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.protocol.ExporterPositionsDecoder;
import io.camunda.zeebe.broker.protocol.ExporterPositionsEncoder;
import io.camunda.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.HashMap;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.MutableInteger;

public class ExporterPositionsMessage
extends SbeBufferWriterReader<ExporterPositionsEncoder, ExporterPositionsDecoder> {
    private final Map<String, Long> exporterPositions = new HashMap<String, Long>();
    private final ExporterPositionsEncoder encoder = new ExporterPositionsEncoder();
    private final ExporterPositionsDecoder decoder = new ExporterPositionsDecoder();

    protected ExporterPositionsEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected ExporterPositionsDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        super.reset();
        this.exporterPositions.clear();
    }

    public int getLength() {
        MutableInteger length = new MutableInteger();
        this.exporterPositions.forEach((id, pos) -> length.addAndGet(ExporterPositionsEncoder.PositionsEncoder.positionEncodingLength() + ExporterPositionsEncoder.PositionsEncoder.exporterIdHeaderLength() + id.length()));
        return super.getLength() + ExporterPositionsEncoder.PositionsEncoder.sbeHeaderSize() + length.get();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        ExporterPositionsEncoder.PositionsEncoder positionsEncoder = this.encoder.positionsCount(this.exporterPositions.size());
        this.exporterPositions.forEach((id, pos) -> {
            DirectBuffer idBuffer = BufferUtil.wrapString((String)id);
            positionsEncoder.next().position((long)pos).putExporterId(idBuffer, 0, idBuffer.capacity());
        });
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        ExporterPositionsDecoder.PositionsDecoder positionsDecoder = this.decoder.positions();
        while (positionsDecoder.hasNext()) {
            ExporterPositionsDecoder.PositionsDecoder next = positionsDecoder.next();
            long position = next.position();
            int exporterIdLength = next.exporterIdLength();
            byte[] bytes = new byte[exporterIdLength];
            next.getExporterId(bytes, 0, exporterIdLength);
            this.exporterPositions.put(new String(bytes), position);
        }
    }

    public void putExporter(String exporterId, long lastExportedPosition) {
        this.exporterPositions.put(exporterId, lastExportedPosition);
    }

    public Map<String, Long> getExporterPositions() {
        return this.exporterPositions;
    }
}

