/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.camunda.zeebe.broker.exporter.debug.DebugLogExporter;
import io.camunda.zeebe.broker.exporter.metrics.MetricsExporter;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.configuration.EmbeddedGatewayCfg;
import io.camunda.zeebe.broker.system.configuration.ExperimentalCfg;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import io.camunda.zeebe.broker.system.configuration.ThreadsCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.BackpressureCfg;
import io.camunda.zeebe.util.Environment;
import io.camunda.zeebe.util.ObjectWriterFactory;
import io.camunda.zeebe.util.exception.UncheckedExecutionException;
import java.util.HashMap;
import java.util.Map;

public final class BrokerCfg {
    static final String ENV_DEBUG_EXPORTER = "ZEEBE_DEBUG";
    private NetworkCfg network = new NetworkCfg();
    private ClusterCfg cluster = new ClusterCfg();
    private ThreadsCfg threads = new ThreadsCfg();
    private DataCfg data = new DataCfg();
    private Map<String, ExporterCfg> exporters = new HashMap<String, ExporterCfg>();
    private EmbeddedGatewayCfg gateway = new EmbeddedGatewayCfg();
    private BackpressureCfg backpressure = new BackpressureCfg();
    private ExperimentalCfg experimental = new ExperimentalCfg();
    private boolean executionMetricsExporterEnabled;

    public void init(String brokerBase) {
        this.init(brokerBase, new Environment());
    }

    public void init(String brokerBase, Environment environment) {
        this.applyEnvironment(environment);
        if (this.isExecutionMetricsExporterEnabled()) {
            this.exporters.put(MetricsExporter.defaultExporterId(), MetricsExporter.defaultConfig());
        }
        this.network.init(this, brokerBase);
        this.cluster.init(this, brokerBase);
        this.threads.init(this, brokerBase);
        this.data.init(this, brokerBase);
        this.exporters.values().forEach(e -> e.init(this, brokerBase));
        this.gateway.init(this, brokerBase);
        this.backpressure.init(this, brokerBase);
        this.experimental.init(this, brokerBase);
    }

    private void applyEnvironment(Environment environment) {
        if (environment.getBool(ENV_DEBUG_EXPORTER).orElse(false).booleanValue()) {
            this.exporters.put(DebugLogExporter.defaultExporterId(), DebugLogExporter.defaultConfig());
        }
    }

    public NetworkCfg getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkCfg network) {
        this.network = network;
    }

    public ClusterCfg getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterCfg cluster) {
        this.cluster = cluster;
    }

    public ThreadsCfg getThreads() {
        return this.threads;
    }

    public void setThreads(ThreadsCfg threads) {
        this.threads = threads;
    }

    public DataCfg getData() {
        return this.data;
    }

    public void setData(DataCfg logs) {
        this.data = logs;
    }

    public Map<String, ExporterCfg> getExporters() {
        return this.exporters;
    }

    public void setExporters(Map<String, ExporterCfg> exporters) {
        this.exporters = exporters;
    }

    public EmbeddedGatewayCfg getGateway() {
        return this.gateway;
    }

    public BrokerCfg setGateway(EmbeddedGatewayCfg gateway) {
        this.gateway = gateway;
        return this;
    }

    public BackpressureCfg getBackpressure() {
        return this.backpressure;
    }

    public BrokerCfg setBackpressure(BackpressureCfg backpressure) {
        this.backpressure = backpressure;
        return this;
    }

    public boolean isExecutionMetricsExporterEnabled() {
        return this.executionMetricsExporterEnabled;
    }

    public void setExecutionMetricsExporterEnabled(boolean executionMetricsExporterEnabled) {
        this.executionMetricsExporterEnabled = executionMetricsExporterEnabled;
    }

    public ExperimentalCfg getExperimental() {
        return this.experimental;
    }

    public void setExperimental(ExperimentalCfg experimental) {
        this.experimental = experimental;
    }

    public String toString() {
        return "BrokerCfg{network=" + this.network + ", cluster=" + this.cluster + ", threads=" + this.threads + ", data=" + this.data + ", exporters=" + this.exporters + ", gateway=" + this.gateway + ", backpressure=" + this.backpressure + ", experimental=" + this.experimental + ", executionMetricsExporterEnabled=" + this.executionMetricsExporterEnabled + "}";
    }

    public String toJson() {
        try {
            return ObjectWriterFactory.getDefaultJsonObjectWriter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedExecutionException("Writing to JSON failed", (Throwable)e);
        }
    }
}

