/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.management;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.exporter.stream.ExporterPhase;
import io.camunda.zeebe.broker.partitioning.NoOpPartitionAdminAccess;
import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.broker.system.management.BrokerAdminService;
import io.camunda.zeebe.broker.system.management.PartitionStatus;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotId;
import io.camunda.zeebe.streamprocessor.StreamProcessor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

public final class BrokerAdminServiceImpl
extends Actor
implements BrokerAdminService {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private PartitionAdminAccess adminAccess = new NoOpPartitionAdminAccess();
    private List<ZeebePartition> partitions = Collections.emptyList();

    public void injectAdminAccess(PartitionAdminAccess adminAccess) {
        this.adminAccess = Objects.requireNonNull(adminAccess);
    }

    public void injectPartitionInfoSource(@Deprecated List<ZeebePartition> partitions) {
        this.partitions = partitions;
    }

    @Override
    public void pauseStreamProcessing() {
        this.actor.call(this::pauseStreamProcessingOnAllPartitions);
    }

    @Override
    public void resumeStreamProcessing() {
        LOG.info("Resuming paused StreamProcessor on all partitions.");
        this.actor.call(() -> this.adminAccess.resumeProcessing());
    }

    @Override
    public void pauseExporting() {
        this.actor.call(this::pauseExportingOnAllPartitions);
    }

    @Override
    public void resumeExporting() {
        LOG.info("Resuming exporting on all partitions.");
        this.actor.call(() -> this.adminAccess.resumeExporting());
    }

    @Override
    public void takeSnapshot() {
        this.actor.call(this::takeSnapshotOnAllPartitions);
    }

    @Override
    public void prepareForUpgrade() {
        this.actor.call(this::prepareAllPartitionsForSafeUpgrade);
    }

    @Override
    public Map<Integer, PartitionStatus> getPartitionStatus() {
        CompletableFuture future = new CompletableFuture();
        ConcurrentHashMap partitionStatuses = new ConcurrentHashMap();
        this.actor.call(() -> {
            if (this.partitions.isEmpty()) {
                future.complete(partitionStatuses);
            } else {
                List statusFutures = this.partitions.stream().map(partition -> this.getPartitionStatus((ZeebePartition)partition).whenComplete((ps, error) -> {
                    if (error == null) {
                        partitionStatuses.put(partition.getPartitionId(), ps);
                    }
                })).collect(Collectors.toList());
                CompletableFuture.allOf((CompletableFuture[])statusFutures.toArray(CompletableFuture[]::new)).thenAccept(r -> future.complete(partitionStatuses));
            }
        });
        try {
            return (Map)future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.warn("Error when querying partition status", (Throwable)e);
            return Map.of();
        }
    }

    private CompletableFuture<PartitionStatus> getPartitionStatus(ZeebePartition partition) {
        CompletableFuture<PartitionStatus> partitionStatus = new CompletableFuture<PartitionStatus>();
        ActorFuture<RaftServer.Role> currentRoleFuture = partition.getCurrentRole();
        ActorFuture<Optional<StreamProcessor>> streamProcessorFuture = partition.getStreamProcessor();
        ActorFuture<Optional<ExporterDirector>> exporterDirectorFuture = partition.getExporterDirector();
        this.actor.runOnCompletion(List.of(streamProcessorFuture, exporterDirectorFuture), error -> {
            if (error != null) {
                partitionStatus.completeExceptionally((Throwable)error);
                return;
            }
            if (currentRoleFuture.join() == RaftServer.Role.LEADER) {
                Optional streamProcessor = (Optional)streamProcessorFuture.join();
                Optional exporterDirector = (Optional)exporterDirectorFuture.join();
                if (streamProcessor.isEmpty() || exporterDirector.isEmpty()) {
                    partitionStatus.completeExceptionally(new IllegalStateException("No streamprocessor or exporter found for leader partition."));
                } else {
                    this.getLeaderPartitionStatus(partition, (StreamProcessor)streamProcessor.get(), (ExporterDirector)((Object)((Object)exporterDirector.get())), partitionStatus);
                }
            } else {
                this.getFollowerPartitionStatus(partition, partitionStatus);
            }
        });
        return partitionStatus;
    }

    private void getFollowerPartitionStatus(ZeebePartition partition, CompletableFuture<PartitionStatus> partitionStatus) {
        Optional<String> snapshotId = this.getSnapshotId(partition);
        Long processedPositionInSnapshot = snapshotId.flatMap(FileBasedSnapshotId::ofFileName).map(FileBasedSnapshotId::getProcessedPosition).orElse(null);
        PartitionStatus status = PartitionStatus.ofFollower(snapshotId.orElse(null), processedPositionInSnapshot);
        partitionStatus.complete(status);
    }

    private void getLeaderPartitionStatus(ZeebePartition partition, StreamProcessor streamProcessor, ExporterDirector exporterDirector, CompletableFuture<PartitionStatus> partitionStatus) {
        ActorFuture positionFuture = streamProcessor.getLastProcessedPositionAsync();
        ActorFuture currentPhaseFuture = streamProcessor.getCurrentPhase();
        ActorFuture<ExporterPhase> exporterPhaseFuture = exporterDirector.getPhase();
        ActorFuture<Long> exporterPositionFuture = exporterDirector.getLowestPosition();
        Optional<String> snapshotId = this.getSnapshotId(partition);
        Long processedPositionInSnapshot = snapshotId.flatMap(FileBasedSnapshotId::ofFileName).map(FileBasedSnapshotId::getProcessedPosition).orElse(null);
        this.actor.runOnCompletion(List.of(positionFuture, currentPhaseFuture, exporterPhaseFuture, exporterPositionFuture), error -> {
            if (error != null) {
                partitionStatus.completeExceptionally((Throwable)error);
                return;
            }
            Long processedPosition = (Long)positionFuture.join();
            StreamProcessor.Phase processorPhase = (StreamProcessor.Phase)currentPhaseFuture.join();
            ExporterPhase exporterPhase = (ExporterPhase)((Object)((Object)exporterPhaseFuture.join()));
            Long exporterPosition = (Long)exporterPositionFuture.join();
            PartitionStatus status = PartitionStatus.ofLeader(processedPosition, snapshotId.orElse(null), processedPositionInSnapshot, processorPhase, exporterPhase, exporterPosition);
            partitionStatus.complete(status);
        });
    }

    private Optional<String> getSnapshotId(ZeebePartition partition) {
        return partition.getSnapshotStore().getLatestSnapshot().map(PersistedSnapshot::getId);
    }

    private void prepareAllPartitionsForSafeUpgrade() {
        LOG.info("Preparing for safe upgrade.");
        ActorFuture<Void> pauseProcessingCompleted = this.pauseStreamProcessingOnAllPartitions();
        ActorFuture<Void> pauseExportingCompleted = this.pauseExportingOnAllPartitions();
        List pauseAll = Stream.of(pauseProcessingCompleted, pauseExportingCompleted).collect(Collectors.toList());
        this.actor.runOnCompletion(pauseAll, t -> this.takeSnapshotOnAllPartitions());
    }

    private ActorFuture<Void> pauseStreamProcessingOnAllPartitions() {
        LOG.info("Pausing StreamProcessor on all partitions.");
        return this.adminAccess.pauseProcessing();
    }

    private ActorFuture<Void> takeSnapshotOnAllPartitions() {
        LOG.info("Triggering Snapshots on all partitions.");
        return this.adminAccess.takeSnapshot();
    }

    private ActorFuture<Void> pauseExportingOnAllPartitions() {
        LOG.info("Pausing exporting on all partitions.");
        return this.adminAccess.pauseExporting();
    }
}

