/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.transport.backupapi.BackupApiRequestHandler;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;

public final class BackupApiRequestHandlerStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        BackupApiRequestHandler backupApiRequestHandler = context.getBackupApiRequestHandler();
        if (backupApiRequestHandler != null) {
            context.getDiskSpaceUsageMonitor().removeDiskUsageListener(backupApiRequestHandler);
            ActorFuture closeFuture = backupApiRequestHandler.closeAsync();
            context.setBackupApiRequestHandler(null);
            return closeFuture;
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        if (targetRole == RaftServer.Role.LEADER) {
            return this.installRequestHandler(context);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "BackupApiRequestHandler";
    }

    private ActorFuture<Void> installRequestHandler(PartitionTransitionContext context) {
        ActorFuture installed = context.getConcurrencyControl().createFuture();
        ActorFuture writerFuture = context.getLogStream().newLogStreamRecordWriter();
        writerFuture.onComplete((logStreamRecordWriter, error) -> {
            if (error == null) {
                this.createBackupApiRequestHandler(context, (ActorFuture<Void>)installed, (LogStreamRecordWriter)logStreamRecordWriter);
            } else {
                installed.completeExceptionally(error);
            }
        });
        return installed;
    }

    private void createBackupApiRequestHandler(PartitionTransitionContext context, ActorFuture<Void> installed, LogStreamRecordWriter logStreamRecordWriter) {
        BackupApiRequestHandler requestHandler = new BackupApiRequestHandler(context.getGatewayBrokerTransport(), logStreamRecordWriter, context.getBackupManager(), context.getPartitionId(), context.getBrokerCfg().getExperimental().getFeatures().isEnableBackup());
        context.getActorSchedulingService().submitActor((Actor)requestHandler).onComplete(installed);
        installed.onComplete((ignore, error) -> {
            if (error == null) {
                context.setBackupApiRequestHandler(requestHandler);
                context.getDiskSpaceUsageMonitor().addDiskUsageListener(requestHandler);
            }
        });
    }
}

