/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.partitionapi;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.backup.api.CheckpointListener;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.camunda.zeebe.broker.transport.partitionapi.InterPartitionCommandReceiverImpl;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import java.util.Map;
import org.slf4j.Logger;

public final class InterPartitionCommandReceiverActor
extends Actor
implements DiskSpaceUsageListener,
CheckpointListener {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    private final String actorName;
    private final ClusterCommunicationService communicationService;
    private final int partitionId;
    private final InterPartitionCommandReceiverImpl receiver;

    public InterPartitionCommandReceiverActor(int nodeId, int partitionId, ClusterCommunicationService communicationService, LogStreamRecordWriter logStreamWriter) {
        this.partitionId = partitionId;
        this.communicationService = communicationService;
        this.receiver = new InterPartitionCommandReceiverImpl(logStreamWriter);
        this.actorName = InterPartitionCommandReceiverActor.buildActorName((int)nodeId, (String)this.getClass().getSimpleName(), (int)partitionId);
    }

    protected Map<String, String> createContext() {
        Map context = super.createContext();
        context.put("partitionId", Integer.toString(this.partitionId));
        return context;
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarting() {
        this.communicationService.subscribe("inter-partition-" + this.partitionId, this::tryHandleMessage, arg_0 -> ((ActorControl)this.actor).run(arg_0));
    }

    protected void onActorClosing() {
        this.communicationService.unsubscribe("inter-partition-" + this.partitionId);
    }

    @Override
    public void onDiskSpaceNotAvailable() {
        this.actor.run(() -> this.receiver.setDiskSpaceAvailable(false));
    }

    @Override
    public void onDiskSpaceAvailable() {
        this.actor.run(() -> this.receiver.setDiskSpaceAvailable(true));
    }

    public void onNewCheckpointCreated(long checkpointId) {
        this.actor.run(() -> this.receiver.setCheckpointId(checkpointId));
    }

    private void tryHandleMessage(MemberId memberId, byte[] message) {
        try {
            this.receiver.handleMessage(memberId, message);
        }
        catch (RuntimeException e) {
            LOG.error("Error while handling message", (Throwable)e);
        }
    }
}

