/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.partitionapi;

import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.backup.api.CheckpointListener;
import io.camunda.zeebe.broker.partitioning.topology.TopologyPartitionListener;
import io.camunda.zeebe.broker.transport.partitionapi.InterPartitionCommandSenderImpl;
import io.camunda.zeebe.engine.api.InterPartitionCommandSender;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.util.buffer.BufferWriter;

public final class InterPartitionCommandSenderService
extends Actor
implements InterPartitionCommandSender,
CheckpointListener,
TopologyPartitionListener {
    final InterPartitionCommandSenderImpl commandSender;
    final int partitionId;

    public InterPartitionCommandSenderService(ClusterCommunicationService communicationService, int partitionId) {
        this.commandSender = new InterPartitionCommandSenderImpl(communicationService);
        this.partitionId = partitionId;
    }

    public void onNewCheckpointCreated(long checkpointId) {
        this.actor.submit(() -> this.commandSender.setCheckpointId(checkpointId));
    }

    public void sendCommand(int receiverPartitionId, ValueType valueType, Intent intent, BufferWriter command) {
        this.actor.submit(() -> this.commandSender.sendCommand(receiverPartitionId, valueType, intent, command));
    }

    public void sendCommand(int receiverPartitionId, ValueType valueType, Intent intent, Long recordKey, BufferWriter command) {
        this.actor.submit(() -> this.commandSender.sendCommand(receiverPartitionId, valueType, intent, recordKey, command));
    }

    @Override
    public void onPartitionLeaderUpdated(int partitionId, BrokerInfo member) {
        this.actor.submit(() -> this.commandSender.setCurrentLeader(partitionId, member.getNodeId()));
    }
}

