/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.management.BackupStatusCode;
import io.camunda.zeebe.protocol.management.BackupStatusResponseDecoder;
import io.camunda.zeebe.protocol.management.BackupStatusResponseEncoder;
import io.camunda.zeebe.protocol.management.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.management.MessageHeaderEncoder;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.io.UnsupportedEncodingException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;

public class BackupStatusResponse
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final BackupStatusResponseEncoder bodyEncoder = new BackupStatusResponseEncoder();
    private final BackupStatusResponseDecoder bodyDecoder = new BackupStatusResponseDecoder();
    private long backupId;
    private int partitionId;
    private int brokerId;
    private BackupStatusCode status;
    private long checkpointPosition = BackupStatusResponseEncoder.checkpointPositionNullValue();
    private int numberOfPartitions = BackupStatusResponseEncoder.numberOfPartitionsNullValue();
    private String snapshotId = "";
    private byte[] encodedSnapshotId = ArrayUtil.EMPTY_BYTE_ARRAY;
    private String failureReason = "";
    private byte[] encodedFailureReason = ArrayUtil.EMPTY_BYTE_ARRAY;
    private String brokerVersion = "";
    private byte[] encodedBrokerVersion = ArrayUtil.EMPTY_BYTE_ARRAY;
    private String createdAt = "";
    private byte[] encodedCreatedAt = ArrayUtil.EMPTY_BYTE_ARRAY;
    private String lastUpdated = "";
    private byte[] encodedLastUpdated = ArrayUtil.EMPTY_BYTE_ARRAY;

    public long getBackupId() {
        return this.backupId;
    }

    public BackupStatusResponse setBackupId(long backupId) {
        this.backupId = backupId;
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public BackupStatusResponse setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public BackupStatusResponse setBrokerId(int brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    public BackupStatusCode getStatus() {
        return this.status;
    }

    public BackupStatusResponse setStatus(BackupStatusCode status) {
        this.status = status;
        return this;
    }

    public long getCheckpointPosition() {
        return this.checkpointPosition;
    }

    public BackupStatusResponse setCheckpointPosition(long checkpointPosition) {
        this.checkpointPosition = checkpointPosition;
        return this;
    }

    public int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public BackupStatusResponse setNumberOfPartitions(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
        return this;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public BackupStatusResponse setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        this.encodedSnapshotId = this.encodeString(snapshotId, BackupStatusResponseEncoder.snapshotIdCharacterEncoding());
        return this;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public BackupStatusResponse setFailureReason(String failureReason) {
        this.failureReason = failureReason;
        this.encodedFailureReason = this.encodeString(failureReason, BackupStatusResponseEncoder.failureReasonCharacterEncoding());
        return this;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public BackupStatusResponse setBrokerVersion(String brokerVersion) {
        this.brokerVersion = brokerVersion;
        this.encodedBrokerVersion = this.encodeString(brokerVersion, BackupStatusResponseEncoder.brokerVersionCharacterEncoding());
        return this;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public BackupStatusResponse setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        this.encodedCreatedAt = this.encodeString(createdAt, BackupStatusResponseEncoder.createdAtCharacterEncoding());
        return this;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public BackupStatusResponse setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        this.encodedLastUpdated = this.encodeString(lastUpdated, BackupStatusResponseEncoder.lastUpdatedCharacterEncoding());
        return this;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.bodyDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
        this.backupId = this.bodyDecoder.backupId();
        this.partitionId = this.bodyDecoder.partitionId();
        this.status = this.bodyDecoder.status();
        this.brokerId = this.bodyDecoder.brokerId();
        this.checkpointPosition = this.bodyDecoder.checkpointPosition();
        this.numberOfPartitions = this.bodyDecoder.numberOfPartitions();
        this.encodedSnapshotId = new byte[this.bodyDecoder.snapshotIdLength()];
        this.bodyDecoder.getSnapshotId(this.encodedSnapshotId, 0, this.encodedSnapshotId.length);
        this.snapshotId = this.decodeString(this.encodedSnapshotId, BackupStatusResponseDecoder.snapshotIdCharacterEncoding());
        this.encodedFailureReason = new byte[this.bodyDecoder.failureReasonLength()];
        this.bodyDecoder.getFailureReason(this.encodedFailureReason, 0, this.encodedFailureReason.length);
        this.failureReason = this.decodeString(this.encodedFailureReason, BackupStatusResponseDecoder.failureReasonCharacterEncoding());
        this.encodedBrokerVersion = new byte[this.bodyDecoder.brokerVersionLength()];
        this.bodyDecoder.getBrokerVersion(this.encodedBrokerVersion, 0, this.encodedBrokerVersion.length);
        this.brokerVersion = this.decodeString(this.encodedBrokerVersion, BackupStatusResponseDecoder.brokerVersionCharacterEncoding());
        this.encodedCreatedAt = new byte[this.bodyDecoder.createdAtLength()];
        this.bodyDecoder.getCreatedAt(this.encodedCreatedAt, 0, this.encodedCreatedAt.length);
        this.createdAt = this.decodeString(this.encodedCreatedAt, BackupStatusResponseDecoder.createdAtCharacterEncoding());
        this.encodedLastUpdated = new byte[this.bodyDecoder.lastUpdatedLength()];
        this.bodyDecoder.getLastUpdated(this.encodedLastUpdated, 0, this.encodedLastUpdated.length);
        this.lastUpdated = this.decodeString(this.encodedLastUpdated, BackupStatusResponseDecoder.lastUpdatedCharacterEncoding());
    }

    private String decodeString(byte[] encodedSnapshotId, String charsetName) {
        try {
            return new String(encodedSnapshotId, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength() + BackupStatusResponseEncoder.snapshotIdHeaderLength() + this.encodedSnapshotId.length + BackupStatusResponseEncoder.failureReasonHeaderLength() + this.encodedFailureReason.length + BackupStatusResponseEncoder.brokerVersionHeaderLength() + this.encodedBrokerVersion.length + BackupStatusResponseEncoder.createdAtHeaderLength() + this.encodedCreatedAt.length + BackupStatusResponseEncoder.lastUpdatedHeaderLength() + this.encodedLastUpdated.length;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.bodyEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder);
        this.bodyEncoder.backupId(this.backupId).brokerId(this.brokerId).partitionId(this.partitionId).checkpointPosition(this.checkpointPosition).numberOfPartitions(this.numberOfPartitions).status(this.status).putSnapshotId(this.encodedSnapshotId, 0, this.encodedSnapshotId.length).putFailureReason(this.encodedFailureReason, 0, this.encodedFailureReason.length).putBrokerVersion(this.encodedBrokerVersion, 0, this.encodedBrokerVersion.length).putCreatedAt(this.encodedCreatedAt, 0, this.encodedCreatedAt.length).putLastUpdated(this.encodedLastUpdated, 0, this.encodedLastUpdated.length);
    }

    private byte[] encodeString(String value, String charsetName) {
        try {
            return null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

