/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationVariableInstruction;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;

@JsonIgnoreProperties(value={"encodedLength"})
public final class ProcessInstanceModificationActivateInstruction
extends ObjectValue
implements ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue {
    private final StringProperty elementIdProperty = new StringProperty("elementId");
    private final LongProperty ancestorScopeKeyProperty = new LongProperty("ancestorScopeKey", -1L);
    private final ArrayProperty<ProcessInstanceModificationVariableInstruction> variableInstructionsProperty = new ArrayProperty("variableInstructions", (BaseValue)new ProcessInstanceModificationVariableInstruction());

    public ProcessInstanceModificationActivateInstruction() {
        this.declareProperty((BaseProperty)this.elementIdProperty).declareProperty((BaseProperty)this.ancestorScopeKeyProperty).declareProperty(this.variableInstructionsProperty);
    }

    public String getElementId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.getElementIdBuffer());
    }

    public long getAncestorScopeKey() {
        return this.ancestorScopeKeyProperty.getValue();
    }

    public List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> getVariableInstructions() {
        return this.variableInstructionsProperty.stream().map(instruction -> {
            ProcessInstanceModificationVariableInstruction copy = new ProcessInstanceModificationVariableInstruction();
            copy.copy((ProcessInstanceModificationVariableInstruction)((Object)instruction));
            return copy;
        }).toList();
    }

    public ProcessInstanceModificationActivateInstruction setAncestorScopeKey(long ancestorScopeKey) {
        this.ancestorScopeKeyProperty.setValue(ancestorScopeKey);
        return this;
    }

    public ProcessInstanceModificationActivateInstruction setElementId(String elementId) {
        this.elementIdProperty.setValue(elementId);
        return this;
    }

    @JsonIgnore
    public boolean hasVariableInstructions() {
        return !this.variableInstructionsProperty.isEmpty();
    }

    public ProcessInstanceModificationActivateInstruction addVariableInstruction(ProcessInstanceModificationVariableInstruction variableInstruction) {
        ((ProcessInstanceModificationVariableInstruction)this.variableInstructionsProperty.add()).copy(variableInstruction);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProperty.getValue();
    }

    public void copy(ProcessInstanceModificationActivateInstruction object) {
        this.setElementId(object.getElementId());
        this.setAncestorScopeKey(object.getAncestorScopeKey());
        object.getVariableInstructions().stream().map(ProcessInstanceModificationVariableInstruction.class::cast).forEach(this::addVariableInstruction);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }
}

