/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.SegmentDescriptor;
import io.camunda.zeebe.journal.file.SegmentFile;
import io.camunda.zeebe.journal.file.SegmentReader;
import io.camunda.zeebe.journal.file.SegmentWriter;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import org.agrona.IoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Segment
implements AutoCloseable {
    private static final ByteOrder ENDIANNESS = ByteOrder.LITTLE_ENDIAN;
    private static final Logger LOG = LoggerFactory.getLogger(Segment.class);
    private final SegmentFile file;
    private final SegmentDescriptor descriptor;
    private final JournalIndex index;
    private final SegmentWriter writer;
    private final Set<SegmentReader> readers = Sets.newConcurrentHashSet();
    private boolean open = true;
    private final MappedByteBuffer buffer;
    private volatile boolean markedForDeletion = false;

    public Segment(SegmentFile file, SegmentDescriptor descriptor, MappedByteBuffer buffer, long lastWrittenIndex, long lastWrittenAsqn, JournalIndex index) {
        this.file = file;
        this.descriptor = descriptor;
        this.buffer = buffer;
        this.index = index;
        this.writer = this.createWriter(lastWrittenIndex, lastWrittenAsqn);
    }

    public long id() {
        return this.descriptor.id();
    }

    public long index() {
        return this.descriptor.index();
    }

    public long lastIndex() {
        return this.writer.getLastIndex();
    }

    public long lastAsqn() {
        return this.writer.getLastAsqn();
    }

    public SegmentFile file() {
        return this.file;
    }

    public SegmentDescriptor descriptor() {
        return this.descriptor;
    }

    public boolean isEmpty() {
        return this.length() == 0L;
    }

    public long length() {
        return this.writer.getNextIndex() - this.index();
    }

    public SegmentWriter writer() {
        this.checkOpen();
        return this.writer;
    }

    SegmentReader createReader() {
        this.checkOpen();
        SegmentReader reader = new SegmentReader(this.buffer.asReadOnlyBuffer().position(0).order(ENDIANNESS), this, this.index);
        this.readers.add(reader);
        return reader;
    }

    private SegmentWriter createWriter(long lastWrittenIndex, long lastWrittenAsqn) {
        return new SegmentWriter(this.buffer, this, this.index, lastWrittenIndex, lastWrittenAsqn);
    }

    void onReaderClosed(SegmentReader reader) {
        this.readers.remove(reader);
        if (this.markedForDeletion && this.readers.isEmpty()) {
            this.safeDelete();
        }
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.open, (Object)"Segment not open");
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.open = false;
        this.readers.forEach(SegmentReader::close);
        IoUtil.unmap((MappedByteBuffer)this.buffer);
    }

    public void delete() {
        this.open = false;
        this.markForDeletion();
        if (this.readers.isEmpty()) {
            this.safeDelete();
        }
    }

    private void safeDelete() {
        if (!this.readers.isEmpty()) {
            throw new JournalException(String.format("Cannot delete segment file. There are %d readers referring to this segment.", this.readers.size()));
        }
        try {
            IoUtil.unmap((MappedByteBuffer)this.buffer);
            Files.deleteIfExists(this.file.getFileMarkedForDeletion());
        }
        catch (IOException e) {
            LOG.warn("Could not delete segment {}. File to delete {}. This can lead to increased disk usage.", new Object[]{this, this.file.getFileMarkedForDeletion(), e});
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("index", this.index()).toString();
    }

    private void markForDeletion() {
        if (this.markedForDeletion) {
            return;
        }
        this.writer.close();
        Path target = this.file.getFileMarkedForDeletion();
        try {
            FileUtil.moveDurably((Path)this.file.file().toPath(), (Path)target, (CopyOption[])new CopyOption[0]);
        }
        catch (IOException e) {
            throw new JournalException(e);
        }
        this.markedForDeletion = true;
    }
}

