/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.camunda.zeebe.journal.Journal;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.JournalReader;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.JournalMetrics;
import io.camunda.zeebe.journal.file.Segment;
import io.camunda.zeebe.journal.file.SegmentedJournalBuilder;
import io.camunda.zeebe.journal.file.SegmentedJournalReader;
import io.camunda.zeebe.journal.file.SegmentedJournalWriter;
import io.camunda.zeebe.journal.file.SegmentsManager;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.StampedLock;

public final class SegmentedJournal
implements Journal {
    public static final long ASQN_IGNORE = -1L;
    private static final int SEGMENT_BUFFER_FACTOR = 3;
    private final JournalMetrics journalMetrics;
    private final File directory;
    private final int maxSegmentSize;
    private final Collection<SegmentedJournalReader> readers = Sets.newConcurrentHashSet();
    private volatile boolean open = true;
    private final long minFreeDiskSpace;
    private final JournalIndex journalIndex;
    private final SegmentedJournalWriter writer;
    private final StampedLock rwlock = new StampedLock();
    private final SegmentsManager segments;

    SegmentedJournal(File directory, int maxSegmentSize, long minFreeDiskSpace, JournalIndex journalIndex, SegmentsManager segments, JournalMetrics journalMetrics) {
        this.directory = Objects.requireNonNull(directory, "must specify a journal directory");
        this.maxSegmentSize = maxSegmentSize;
        this.minFreeDiskSpace = minFreeDiskSpace;
        this.journalMetrics = Objects.requireNonNull(journalMetrics, "must specify journal metrics");
        this.journalIndex = Objects.requireNonNull(journalIndex, "must specify a journal index");
        this.segments = Objects.requireNonNull(segments, "must specify a journal segments manager");
        this.segments.open();
        this.writer = new SegmentedJournalWriter(this);
    }

    public static SegmentedJournalBuilder builder() {
        return new SegmentedJournalBuilder();
    }

    @Override
    public JournalRecord append(BufferWriter recordDataWriter) {
        return this.append(-1L, recordDataWriter);
    }

    @Override
    public JournalRecord append(long asqn, BufferWriter recordDataWriter) {
        return this.writer.append(asqn, recordDataWriter);
    }

    @Override
    public void append(JournalRecord record) {
        this.writer.append(record);
    }

    @Override
    public void deleteAfter(long indexExclusive) {
        this.journalMetrics.observeSegmentTruncation(() -> {
            long stamp = this.rwlock.writeLock();
            try {
                this.writer.deleteAfter(indexExclusive);
                this.resetAdvancedReaders(indexExclusive + 1L);
            }
            finally {
                this.rwlock.unlockWrite(stamp);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUntil(long index) {
        long stamp = this.rwlock.writeLock();
        try {
            this.segments.deleteUntil(index);
        }
        finally {
            this.rwlock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(long nextIndex) {
        long stamp = this.rwlock.writeLock();
        try {
            this.journalIndex.clear();
            this.writer.reset(nextIndex);
        }
        finally {
            this.rwlock.unlockWrite(stamp);
        }
    }

    @Override
    public long getLastIndex() {
        return this.writer.getLastIndex();
    }

    @Override
    public long getFirstIndex() {
        Segment firstSegment = this.segments.getFirstSegment();
        return firstSegment != null ? firstSegment.index() : 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.writer.getNextIndex() - this.getFirstSegment().index() == 0L;
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JournalReader openReader() {
        long stamped = this.acquireReadlock();
        try {
            SegmentedJournalReader reader = new SegmentedJournalReader(this);
            this.readers.add(reader);
            SegmentedJournalReader segmentedJournalReader = reader;
            return segmentedJournalReader;
        }
        finally {
            this.releaseReadlock(stamped);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.segments.close();
        this.open = false;
    }

    private void assertOpen() {
        Preconditions.checkState((this.segments.getCurrentSegment() != null ? 1 : 0) != 0, (Object)"journal not open");
    }

    private void assertDiskSpace() {
        if (this.directory().getUsableSpace() < Math.max(this.maxSegmentSize() * 3L, this.minFreeDiskSpace)) {
            throw new JournalException.OutOfDiskSpace("Not enough space to allocate a new journal segment");
        }
    }

    private long maxSegmentSize() {
        return this.maxSegmentSize;
    }

    private File directory() {
        return this.directory;
    }

    Segment getFirstSegment() {
        this.assertOpen();
        return this.segments.getFirstSegment();
    }

    Segment getLastSegment() {
        this.assertOpen();
        return this.segments.getLastSegment();
    }

    Segment getNextSegment() {
        this.assertOpen();
        this.assertDiskSpace();
        return this.segments.getNextSegment();
    }

    Segment getNextSegment(long index) {
        return this.segments.getNextSegment(index);
    }

    Segment getSegment(long index) {
        this.assertOpen();
        return this.segments.getSegment(index);
    }

    public void closeReader(SegmentedJournalReader segmentedJournalReader) {
        this.readers.remove(segmentedJournalReader);
    }

    Segment resetSegments(long index) {
        return this.segments.resetSegments(index);
    }

    synchronized void removeSegment(Segment segment) {
        this.segments.removeSegment(segment);
    }

    void resetAdvancedReaders(long index) {
        for (SegmentedJournalReader reader : this.readers) {
            if (reader.getNextIndex() <= index) continue;
            reader.unsafeSeek(index);
        }
    }

    public JournalMetrics getJournalMetrics() {
        return this.journalMetrics;
    }

    public JournalIndex getJournalIndex() {
        return this.journalIndex;
    }

    long acquireReadlock() {
        return this.rwlock.readLock();
    }

    void releaseReadlock(long stamp) {
        this.rwlock.unlockRead(stamp);
    }
}

