package io.camunda.zeebe.shared.management.openapi.models;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.shared.management.openapi.models.PartitionBackupInfo;
import io.camunda.zeebe.shared.management.openapi.models.StateCode;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Detailed status of a backup. The aggregated state is computed from the backup state of each partition as: - If the backup of all partitions is in state &#39;COMPLETED&#39;, then the overall state is &#39;COMPLETED&#39;. - If one is &#39;FAILED&#39;, then the overall state is &#39;FAILED&#39;. - Otherwise, if one is &#39;DOES_NOT_EXIST&#39;, then the overall state is &#39;INCOMPLETE&#39;. - Otherwise, if one is &#39;IN_PROGRESS&#39;, then the overall state is &#39;IN_PROGRESS&#39;. 
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "BackupInfo", description = "Detailed status of a backup. The aggregated state is computed from the backup state of each partition as: - If the backup of all partitions is in state 'COMPLETED', then the overall state is 'COMPLETED'. - If one is 'FAILED', then the overall state is 'FAILED'. - Otherwise, if one is 'DOES_NOT_EXIST', then the overall state is 'INCOMPLETE'. - Otherwise, if one is 'IN_PROGRESS', then the overall state is 'IN_PROGRESS'. ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-04-05T07:58:08.291865267Z[Etc/UTC]")
public class BackupInfo {

  @JsonProperty("backupId")
  private Long backupId;

  @JsonProperty("state")
  private StateCode state;

  @JsonProperty("failureReason")
  private String failureReason;

  @JsonProperty("details")
  @Valid
  private List<PartitionBackupInfo> details = new ArrayList<>();

  public BackupInfo backupId(Long backupId) {
    this.backupId = backupId;
    return this;
  }

  /**
   * Get backupId
   * @return backupId
  */
  
  @Schema(name = "backupId", accessMode = Schema.AccessMode.READ_ONLY, requiredMode = Schema.RequiredMode.REQUIRED)
  public Long getBackupId() {
    return backupId;
  }

  public void setBackupId(Long backupId) {
    this.backupId = backupId;
  }

  public BackupInfo state(StateCode state) {
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
  */
  @Valid 
  @Schema(name = "state", accessMode = Schema.AccessMode.READ_ONLY, requiredMode = Schema.RequiredMode.REQUIRED)
  public StateCode getState() {
    return state;
  }

  public void setState(StateCode state) {
    this.state = state;
  }

  public BackupInfo failureReason(String failureReason) {
    this.failureReason = failureReason;
    return this;
  }

  /**
   * Reason for failure if the state is 'FAILED'
   * @return failureReason
  */
  
  @Schema(name = "failureReason", example = "", description = "Reason for failure if the state is 'FAILED'", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getFailureReason() {
    return failureReason;
  }

  public void setFailureReason(String failureReason) {
    this.failureReason = failureReason;
  }

  public BackupInfo details(List<PartitionBackupInfo> details) {
    this.details = details;
    return this;
  }

  public BackupInfo addDetailsItem(PartitionBackupInfo detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

  /**
   * Detailed list of the status of the backup per partition. It should always contain all partitions known to the cluster. 
   * @return details
  */
  @Valid 
  @Schema(name = "details", accessMode = Schema.AccessMode.READ_ONLY, description = "Detailed list of the status of the backup per partition. It should always contain all partitions known to the cluster. ", requiredMode = Schema.RequiredMode.REQUIRED)
  public List<PartitionBackupInfo> getDetails() {
    return details;
  }

  public void setDetails(List<PartitionBackupInfo> details) {
    this.details = details;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BackupInfo backupInfo = (BackupInfo) o;
    return Objects.equals(this.backupId, backupInfo.backupId) &&
        Objects.equals(this.state, backupInfo.state) &&
        Objects.equals(this.failureReason, backupInfo.failureReason) &&
        Objects.equals(this.details, backupInfo.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(backupId, state, failureReason, details);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BackupInfo {\n");
    sb.append("    backupId: ").append(toIndentedString(backupId)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    failureReason: ").append(toIndentedString(failureReason)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

