/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.gateway.impl.broker.request.BrokerExecuteCommand;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceResultRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import java.util.List;
import org.agrona.DirectBuffer;

public final class BrokerCreateProcessInstanceWithResultRequest
extends BrokerExecuteCommand<ProcessInstanceResultRecord> {
    private final ProcessInstanceCreationRecord requestDto = new ProcessInstanceCreationRecord();

    public BrokerCreateProcessInstanceWithResultRequest() {
        super(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT);
    }

    public BrokerCreateProcessInstanceWithResultRequest setBpmnProcessId(String bpmnProcessId) {
        this.requestDto.setBpmnProcessId(bpmnProcessId);
        return this;
    }

    public BrokerCreateProcessInstanceWithResultRequest setKey(long key) {
        this.requestDto.setProcessDefinitionKey(key);
        return this;
    }

    public BrokerCreateProcessInstanceWithResultRequest setVersion(int version) {
        this.requestDto.setVersion(version);
        return this;
    }

    public BrokerCreateProcessInstanceWithResultRequest setVariables(DirectBuffer variables) {
        this.requestDto.setVariables(variables);
        return this;
    }

    public BrokerCreateProcessInstanceWithResultRequest setStartInstructions(List<GatewayOuterClass.ProcessInstanceCreationStartInstruction> startInstructionsList) {
        startInstructionsList.stream().map(startInstructionReq -> new ProcessInstanceCreationStartInstruction().setElementId(startInstructionReq.getElementId())).forEach(arg_0 -> ((ProcessInstanceCreationRecord)this.requestDto).addStartInstruction(arg_0));
        return this;
    }

    public BrokerCreateProcessInstanceWithResultRequest setFetchVariables(List<String> fetchVariables) {
        this.requestDto.setFetchVariables(fetchVariables);
        return this;
    }

    public ProcessInstanceCreationRecord getRequestWriter() {
        return this.requestDto;
    }

    @Override
    protected ProcessInstanceResultRecord toResponseDto(DirectBuffer buffer) {
        ProcessInstanceResultRecord responseDto = new ProcessInstanceResultRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }

    @Override
    protected boolean isValidResponse() {
        return this.response.getValueType() == ValueType.PROCESS_INSTANCE_RESULT;
    }
}

