/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.configuration;

import java.time.Duration;

public final class MembershipCfg {
    private static final boolean DEFAULT_BROADCAST_UPDATES = false;
    private static final boolean DEFAULT_BROADCAST_DISPUTES = true;
    private static final boolean DEFAULT_NOTIFY_SUSPECT = false;
    private static final Duration DEFAULT_GOSSIP_INTERVAL = Duration.ofMillis(250L);
    private static final int DEFAULT_GOSSIP_FANOUT = 2;
    private static final Duration DEFAULT_PROBE_INTERVAL = Duration.ofMillis(1000L);
    private static final Duration DEFAULT_PROBE_TIMEOUT = Duration.ofMillis(100L);
    private static final int DEFAULT_SUSPECT_PROBES = 3;
    private static final Duration DEFAULT_FAILURE_TIMEOUT = Duration.ofMillis(10000L);
    private static final Duration DEFAULT_SYNC_INTERVAL = Duration.ofMillis(10000L);
    private boolean broadcastUpdates = false;
    private boolean broadcastDisputes = true;
    private boolean notifySuspect = false;
    private Duration gossipInterval = DEFAULT_GOSSIP_INTERVAL;
    private int gossipFanout = 2;
    private Duration probeInterval = DEFAULT_PROBE_INTERVAL;
    private Duration probeTimeout = DEFAULT_PROBE_TIMEOUT;
    private int suspectProbes = 3;
    private Duration failureTimeout = DEFAULT_FAILURE_TIMEOUT;
    private Duration syncInterval = DEFAULT_SYNC_INTERVAL;

    public boolean isBroadcastUpdates() {
        return this.broadcastUpdates;
    }

    public MembershipCfg setBroadcastUpdates(boolean broadcastUpdates) {
        this.broadcastUpdates = broadcastUpdates;
        return this;
    }

    public boolean isBroadcastDisputes() {
        return this.broadcastDisputes;
    }

    public MembershipCfg setBroadcastDisputes(boolean broadcastDisputes) {
        this.broadcastDisputes = broadcastDisputes;
        return this;
    }

    public boolean isNotifySuspect() {
        return this.notifySuspect;
    }

    public MembershipCfg setNotifySuspect(boolean notifySuspect) {
        this.notifySuspect = notifySuspect;
        return this;
    }

    public Duration getGossipInterval() {
        return this.gossipInterval;
    }

    public MembershipCfg setGossipInterval(Duration gossipInterval) {
        this.gossipInterval = gossipInterval;
        return this;
    }

    public int getGossipFanout() {
        return this.gossipFanout;
    }

    public MembershipCfg setGossipFanout(int gossipFanout) {
        this.gossipFanout = gossipFanout;
        return this;
    }

    public Duration getProbeInterval() {
        return this.probeInterval;
    }

    public MembershipCfg setProbeInterval(Duration probeInterval) {
        this.probeInterval = probeInterval;
        return this;
    }

    public Duration getProbeTimeout() {
        return this.probeTimeout;
    }

    public MembershipCfg setProbeTimeout(Duration probeTimeout) {
        this.probeTimeout = probeTimeout;
        return this;
    }

    public int getSuspectProbes() {
        return this.suspectProbes;
    }

    public MembershipCfg setSuspectProbes(int suspectProbes) {
        this.suspectProbes = suspectProbes;
        return this;
    }

    public Duration getFailureTimeout() {
        return this.failureTimeout;
    }

    public MembershipCfg setFailureTimeout(Duration failureTimeout) {
        this.failureTimeout = failureTimeout;
        return this;
    }

    public Duration getSyncInterval() {
        return this.syncInterval;
    }

    public MembershipCfg setSyncInterval(Duration syncInterval) {
        this.syncInterval = syncInterval;
        return this;
    }

    public int hashCode() {
        int result = this.broadcastUpdates ? 1 : 0;
        result = 31 * result + (this.broadcastDisputes ? 1 : 0);
        result = 31 * result + (this.notifySuspect ? 1 : 0);
        result = 31 * result + (this.gossipInterval != null ? this.gossipInterval.hashCode() : 0);
        result = 31 * result + this.gossipFanout;
        result = 31 * result + (this.probeInterval != null ? this.probeInterval.hashCode() : 0);
        result = 31 * result + (this.probeTimeout != null ? this.probeTimeout.hashCode() : 0);
        result = 31 * result + this.suspectProbes;
        result = 31 * result + (this.failureTimeout != null ? this.failureTimeout.hashCode() : 0);
        result = 31 * result + (this.syncInterval != null ? this.syncInterval.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MembershipCfg that = (MembershipCfg)o;
        if (this.broadcastUpdates != that.broadcastUpdates) {
            return false;
        }
        if (this.broadcastDisputes != that.broadcastDisputes) {
            return false;
        }
        if (this.notifySuspect != that.notifySuspect) {
            return false;
        }
        if (this.gossipFanout != that.gossipFanout) {
            return false;
        }
        if (this.suspectProbes != that.suspectProbes) {
            return false;
        }
        if (this.gossipInterval != null ? !this.gossipInterval.equals(that.gossipInterval) : that.gossipInterval != null) {
            return false;
        }
        if (this.probeInterval != null ? !this.probeInterval.equals(that.probeInterval) : that.probeInterval != null) {
            return false;
        }
        if (this.probeTimeout != null ? !this.probeTimeout.equals(that.probeTimeout) : that.probeTimeout != null) {
            return false;
        }
        if (this.failureTimeout != null ? !this.failureTimeout.equals(that.failureTimeout) : that.failureTimeout != null) {
            return false;
        }
        return this.syncInterval != null ? this.syncInterval.equals(that.syncInterval) : that.syncInterval == null;
    }

    public String toString() {
        return "MembershipCfg{broadcastUpdates=" + this.broadcastUpdates + ", broadcastDisputes=" + this.broadcastDisputes + ", notifySuspect=" + this.notifySuspect + ", gossipInterval=" + this.gossipInterval + ", gossipFanout=" + this.gossipFanout + ", probeInterval=" + this.probeInterval + ", probeTimeout=" + this.probeTimeout + ", suspectProbes=" + this.suspectProbes + ", failureTimeout=" + this.failureTimeout + ", syncInterval=" + this.syncInterval + "}";
    }
}

