/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamApiHandler;
import io.camunda.zeebe.transport.stream.impl.messages.AddStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.RemoveStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.StreamTopics;
import io.camunda.zeebe.util.buffer.BufferReader;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class RemoteStreamEndpoint<M extends BufferReader>
extends Actor {
    private final ClusterCommunicationService transport;
    private final RemoteStreamApiHandler<M> requestHandler;

    public RemoteStreamEndpoint(ClusterCommunicationService transport, RemoteStreamApiHandler<M> requestHandler) {
        this.transport = transport;
        this.requestHandler = requestHandler;
    }

    public void removeAll(MemberId member) {
        this.actor.run(() -> this.requestHandler.removeAll(member));
    }

    protected void onActorStarting() {
        this.transport.subscribe(StreamTopics.ADD.topic(), this::parseAddRequest, this.requestHandler::add, arg_0 -> ((ActorControl)this.actor).run(arg_0));
        this.transport.subscribe(StreamTopics.REMOVE.topic(), this::parseRemoveRequest, this.requestHandler::remove, arg_0 -> ((ActorControl)this.actor).run(arg_0));
        this.transport.subscribe(StreamTopics.REMOVE_ALL.topic(), Function.identity(), this::onRemoveAll, arg_0 -> ((ActorControl)this.actor).run(arg_0));
    }

    protected void onActorClosing() {
        this.transport.unsubscribe(StreamTopics.ADD.topic());
        this.transport.unsubscribe(StreamTopics.REMOVE.topic());
        this.transport.unsubscribe(StreamTopics.REMOVE_ALL.topic());
        this.requestHandler.close();
    }

    private void onRemoveAll(MemberId sender, byte[] ignored) {
        this.requestHandler.removeAll(sender);
    }

    private RemoveStreamRequest parseRemoveRequest(byte[] bytes) {
        return this.parseRequest(bytes, new RemoveStreamRequest());
    }

    private AddStreamRequest parseAddRequest(byte[] bytes) {
        return this.parseRequest(bytes, new AddStreamRequest());
    }

    private <R extends BufferReader> R parseRequest(byte[] bytes, R request) {
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        request.wrap((DirectBuffer)buffer, 0, buffer.capacity());
        return request;
    }
}

