/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.transport.stream.api.RemoteStream;
import io.camunda.zeebe.transport.stream.api.RemoteStreamer;
import io.camunda.zeebe.transport.stream.impl.ImmutableStreamRegistry;
import io.camunda.zeebe.transport.stream.impl.RandomStreamPicker;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamImpl;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamPicker;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamPusher;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.StreamTopics;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class RemoteStreamerImpl<M extends BufferReader, P extends BufferWriter>
extends Actor
implements RemoteStreamer<M, P> {
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(5L);
    private final RemoteStreamPicker<M> streamPicker = new RandomStreamPicker();
    private final ClusterCommunicationService transport;
    private final ImmutableStreamRegistry<M> registry;

    public RemoteStreamerImpl(ClusterCommunicationService transport, ImmutableStreamRegistry<M> registry) {
        this.transport = Objects.requireNonNull(transport, "must specify a network transport");
        this.registry = Objects.requireNonNull(registry, "must specify a job stream registry");
    }

    @Override
    public Optional<RemoteStream<M, P>> streamFor(DirectBuffer streamType) {
        Set<ImmutableStreamRegistry.StreamConsumer<M>> consumers = this.registry.get(new UnsafeBuffer(streamType));
        if (consumers.isEmpty()) {
            return Optional.empty();
        }
        ImmutableStreamRegistry.StreamConsumer<M> target = this.streamPicker.pickStream(consumers);
        RemoteStreamImpl gatewayStream = new RemoteStreamImpl((BufferReader)target.properties(), new RemoteStreamPusher(target.id(), this::send, arg_0 -> ((ActorControl)this.actor).run(arg_0)));
        return Optional.of(gatewayStream);
    }

    private CompletableFuture<Void> send(PushStreamRequest request, MemberId receiver) {
        return this.transport.send(StreamTopics.PUSH.topic(), (Object)request, this::serialize, Function.identity(), receiver, REQUEST_TIMEOUT).thenApply(ok -> null);
    }

    private byte[] serialize(BufferWriter payload) {
        byte[] bytes = new byte[payload.getLength()];
        UnsafeBuffer writeBuffer = new UnsafeBuffer();
        writeBuffer.wrap(bytes);
        payload.write((MutableDirectBuffer)writeBuffer, 0);
        return bytes;
    }
}

