/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableIntermediateThrowEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLink;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.EnsureUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public class IntermediateThrowEventProcessor
implements BpmnElementProcessor<ExecutableIntermediateThrowEvent> {
    private final List<IntermediateThrowEventBehavior> throwEventBehaviors = List.of(new NoneIntermediateThrowEventBehavior(), new MessageIntermediateThrowEventBehavior(), new LinkIntermediateThrowEventBehavior(), new EscalationIntermediateThrowEventBehavior());
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final ExpressionProcessor expressionProcessor;

    public IntermediateThrowEventProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
        this.eventPublicationBehavior = bpmnBehaviors.eventPublicationBehavior();
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
    }

    @Override
    public Class<ExecutableIntermediateThrowEvent> getType() {
        return ExecutableIntermediateThrowEvent.class;
    }

    @Override
    public void onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
        this.eventBehaviorOf(element).onActivate(element, activating);
    }

    @Override
    public void onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
        this.eventBehaviorOf(element).onComplete(element, completing);
    }

    @Override
    public void onTerminate(ExecutableIntermediateThrowEvent element, BpmnElementContext terminating) {
        this.eventBehaviorOf(element).onTerminate(element, terminating);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(terminating);
        this.incidentBehavior.resolveIncidents(terminated);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private IntermediateThrowEventBehavior eventBehaviorOf(ExecutableIntermediateThrowEvent element) {
        return this.throwEventBehaviors.stream().filter(behavior -> behavior.isSuitableForEvent(element)).findFirst().orElseThrow(() -> new UnsupportedOperationException("This kind of intermediate throw event is not supported."));
    }

    private class NoneIntermediateThrowEventBehavior
    implements IntermediateThrowEventBehavior {
        private NoneIntermediateThrowEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isNoneThrowEvent();
        }

        @Override
        public void onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            BpmnElementContext activated = IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
            IntermediateThrowEventProcessor.this.stateTransitionBehavior.completeElement(activated);
        }

        @Override
        public void onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            IntermediateThrowEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).ifRightOrLeft(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> IntermediateThrowEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }
    }

    private class MessageIntermediateThrowEventBehavior
    implements IntermediateThrowEventBehavior {
        private MessageIntermediateThrowEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isMessageThrowEvent();
        }

        @Override
        public void onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            if (element.getJobWorkerProperties() != null) {
                IntermediateThrowEventProcessor.this.variableMappingBehavior.applyInputMappings(activating, element).flatMap(ok -> IntermediateThrowEventProcessor.this.jobBehavior.createNewJob(activating, element)).ifRightOrLeft(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating), failure -> IntermediateThrowEventProcessor.this.incidentBehavior.createIncident((Failure)failure, activating));
            }
        }

        @Override
        public void onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            IntermediateThrowEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).ifRightOrLeft(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> IntermediateThrowEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }

        @Override
        public void onTerminate(ExecutableIntermediateThrowEvent element, BpmnElementContext terminating) {
            if (element.getJobWorkerProperties() != null) {
                IntermediateThrowEventProcessor.this.jobBehavior.cancelJob(terminating);
            }
        }
    }

    private class LinkIntermediateThrowEventBehavior
    implements IntermediateThrowEventBehavior {
        private LinkIntermediateThrowEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isLinkThrowEvent();
        }

        @Override
        public void onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            BpmnElementContext activated = IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
            IntermediateThrowEventProcessor.this.stateTransitionBehavior.completeElement(activated);
        }

        @Override
        public void onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            ExecutableLink link = element.getLink();
            IntermediateThrowEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).ifRightOrLeft(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.activateElementInstanceInFlowScope((BpmnElementContext)completed, link.getCatchEventElement()), failure -> IntermediateThrowEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }
    }

    private class EscalationIntermediateThrowEventBehavior
    implements IntermediateThrowEventBehavior {
        private EscalationIntermediateThrowEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent element) {
            return element.isEscalationThrowEvent();
        }

        @Override
        public void onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext activating) {
            this.evaluateEscalationCode(element, activating).ifRightOrLeft(escalationCode -> {
                BpmnElementContext activated = IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
                boolean canBeCompleted = IntermediateThrowEventProcessor.this.eventPublicationBehavior.throwEscalationEvent(element.getId(), (DirectBuffer)escalationCode, activated);
                if (canBeCompleted) {
                    IntermediateThrowEventProcessor.this.stateTransitionBehavior.completeElement(activated);
                }
            }, failure -> IntermediateThrowEventProcessor.this.incidentBehavior.createIncident((Failure)failure, activating));
        }

        @Override
        public void onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
            IntermediateThrowEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).ifRightOrLeft(completed -> IntermediateThrowEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> IntermediateThrowEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }

        private Either<Failure, DirectBuffer> evaluateEscalationCode(ExecutableIntermediateThrowEvent element, BpmnElementContext context) {
            ExecutableEscalation escalation = element.getEscalation();
            EnsureUtil.ensureNotNull((String)"escalation", (Object)escalation);
            if (escalation.getEscalationCode().isPresent()) {
                return Either.right((Object)escalation.getEscalationCode().get());
            }
            return IntermediateThrowEventProcessor.this.expressionProcessor.evaluateStringExpressionAsDirectBuffer(escalation.getEscalationCodeExpression(), context.getElementInstanceKey());
        }
    }

    private static interface IntermediateThrowEventBehavior {
        public boolean isSuitableForEvent(ExecutableIntermediateThrowEvent var1);

        public void onActivate(ExecutableIntermediateThrowEvent var1, BpmnElementContext var2);

        default public void onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext completing) {
        }

        default public void onTerminate(ExecutableIntermediateThrowEvent element, BpmnElementContext terminating) {
        }
    }
}

