/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.migration.MigrationTaskState;
import io.camunda.zeebe.engine.state.migration.TemporaryVariables;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class DbMigrationState
implements MutableMigrationState {
    private static final MigrationTaskState.State MIGRATION_TASK_FINISHED_STATE = MigrationTaskState.State.FINISHED;
    private final DbString migrationIdentifier = new DbString();
    private final MigrationTaskState migrationTaskState = new MigrationTaskState();
    private final ColumnFamily<DbString, MigrationTaskState> migrationStateColumnFamily;
    private final DbLong messageSubscriptionSentTime;
    private final DbLong messageSubscriptionElementInstanceKey;
    private final DbString messageSubscriptionMessageName;
    private final DbCompositeKey<DbLong, DbString> messageSubscriptionElementKeyAndMessageName;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> messageSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> messageSubscriptionSentTimeColumnFamily;
    private final DbLong processSubscriptionSentTime;
    private final DbLong processSubscriptionElementInstanceKey;
    private final DbString processSubscriptionMessageName;
    private final DbCompositeKey<DbLong, DbString> processSubscriptionElementKeyAndMessageName;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> processSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> processSubscriptionSentTimeColumnFamily;
    private final ColumnFamily<DbLong, TemporaryVariables> temporaryVariableColumnFamily;
    private final DbLong dbDecisionKey;
    private final PersistedDecision dbPersistedDecision;
    private final DbString dbDecisionId;
    private final DbForeignKey<DbLong> fkDecision;
    private final DbInt dbDecisionVersion;
    private final ColumnFamily<DbLong, PersistedDecision> decisionsByKeyColumnFamily;
    private final DbCompositeKey<DbString, DbInt> decisionKeyAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionKeyByDecisionIdAndVersion;
    private final DbLong dbDecisionRequirementsKey;
    private final DbForeignKey<DbLong> fkDecisionRequirements;
    private final PersistedDecisionRequirements dbPersistedDecisionRequirements;
    private final DbInt dbDecisionRequirementsVersion;
    private final DbString dbDecisionRequirementsId;
    private final ColumnFamily<DbLong, PersistedDecisionRequirements> decisionRequirementsByKeyColumnFamily;
    private final DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionRequirementsKeyByIdAndVersionColumnFamily;

    public DbMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.migrationStateColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MIGRATIONS_STATE, transactionContext, (DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
        this.messageSubscriptionElementInstanceKey = new DbLong();
        this.messageSubscriptionMessageName = new DbString();
        this.messageSubscriptionElementKeyAndMessageName = new DbCompositeKey((DbKey)this.messageSubscriptionElementInstanceKey, (DbKey)this.messageSubscriptionMessageName);
        this.messageSubscriptionSentTime = new DbLong();
        this.messageSubscriptionSentTimeCompositeKey = new DbCompositeKey((DbKey)this.messageSubscriptionSentTime, this.messageSubscriptionElementKeyAndMessageName);
        this.messageSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.messageSubscriptionSentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        this.processSubscriptionElementInstanceKey = new DbLong();
        this.processSubscriptionMessageName = new DbString();
        this.processSubscriptionElementKeyAndMessageName = new DbCompositeKey((DbKey)this.processSubscriptionElementInstanceKey, (DbKey)this.processSubscriptionMessageName);
        this.processSubscriptionSentTime = new DbLong();
        this.processSubscriptionSentTimeCompositeKey = new DbCompositeKey((DbKey)this.processSubscriptionSentTime, this.processSubscriptionElementKeyAndMessageName);
        this.processSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.processSubscriptionSentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        DbLong temporaryVariablesKeyInstance = new DbLong();
        TemporaryVariables temporaryVariablesValue = new TemporaryVariables();
        this.temporaryVariableColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TEMPORARY_VARIABLE_STORE, transactionContext, (DbKey)temporaryVariablesKeyInstance, (DbValue)temporaryVariablesValue);
        this.dbDecisionKey = new DbLong();
        this.dbPersistedDecision = new PersistedDecision();
        this.decisionsByKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISIONS, transactionContext, (DbKey)this.dbDecisionKey, (DbValue)this.dbPersistedDecision);
        this.dbDecisionId = new DbString();
        this.fkDecision = new DbForeignKey((DbKey)this.dbDecisionKey, (Enum)ZbColumnFamilies.DMN_DECISIONS);
        this.dbDecisionVersion = new DbInt();
        this.decisionKeyAndVersion = new DbCompositeKey((DbKey)this.dbDecisionId, (DbKey)this.dbDecisionVersion);
        this.decisionKeyByDecisionIdAndVersion = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, transactionContext, this.decisionKeyAndVersion, this.fkDecision);
        this.dbDecisionRequirementsKey = new DbLong();
        this.fkDecisionRequirements = new DbForeignKey((DbKey)this.dbDecisionRequirementsKey, (Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS);
        this.dbPersistedDecisionRequirements = new PersistedDecisionRequirements();
        this.decisionRequirementsByKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS, transactionContext, (DbKey)this.dbDecisionRequirementsKey, (DbValue)this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsVersion = new DbInt();
        this.dbDecisionRequirementsId = new DbString();
        this.decisionRequirementsIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionRequirementsId, (DbKey)this.dbDecisionRequirementsVersion);
        this.decisionRequirementsKeyByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, transactionContext, this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
    }

    @Override
    public void migrateMessageSubscriptionSentTime(MutableMessageSubscriptionState messageSubscriptionState, MutablePendingMessageSubscriptionState transientState) {
        this.messageSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.first()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.second();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.first()).getValue();
            MessageSubscription messageSubscription = messageSubscriptionState.get(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.second()).getBuffer());
            if (messageSubscription != null) {
                messageSubscriptionState.updateToCorrelatingState(messageSubscription.getRecord());
                transientState.updateCommandSentTime(messageSubscription.getRecord(), sentTime);
            }
            this.messageSubscriptionSentTimeColumnFamily.deleteExisting((DbKey)key);
        });
    }

    @Override
    public void migrateProcessMessageSubscriptionSentTime(MutableProcessMessageSubscriptionState persistentState, MutablePendingProcessMessageSubscriptionState transientState) {
        this.processSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.first()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.second();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.first()).getValue();
            ProcessMessageSubscription processMessageSubscription = persistentState.getSubscription(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.second()).getBuffer());
            if (processMessageSubscription != null) {
                ProcessMessageSubscriptionRecord record = processMessageSubscription.getRecord();
                ProcessMessageSubscriptionRecord exclusiveCopy = new ProcessMessageSubscriptionRecord();
                exclusiveCopy.wrap(record);
                if (processMessageSubscription.isOpening()) {
                    persistentState.updateToOpeningState(exclusiveCopy);
                    transientState.updateSentTime(exclusiveCopy, sentTime);
                } else if (processMessageSubscription.isClosing()) {
                    persistentState.updateToClosingState(exclusiveCopy);
                    transientState.updateSentTime(exclusiveCopy, sentTime);
                }
            }
            this.processSubscriptionSentTimeColumnFamily.deleteExisting((DbKey)key);
        });
    }

    @Override
    public void migrateTemporaryVariables(MutableEventScopeInstanceState eventScopeInstanceState, MutableElementInstanceState elementInstanceState) {
        this.temporaryVariableColumnFamily.forEach((key, value) -> {
            long eventKey = -1L;
            String elementId = "migrated-variable-" + key.getValue();
            DirectBuffer elementIdBuffer = BufferUtil.wrapString((String)elementId);
            ElementInstance elementInstance = elementInstanceState.getInstance(key.getValue());
            if (elementInstance != null && elementInstance.getValue().getBpmnElementType().equals((Object)BpmnElementType.EVENT_SUB_PROCESS)) {
                long flowScopeKey = elementInstance.getValue().getFlowScopeKey();
                eventScopeInstanceState.triggerStartEvent(flowScopeKey, -1L, elementIdBuffer, value.get(), elementInstance.getValue().getProcessInstanceKey());
                while (eventScopeInstanceState.pollEventTrigger(key.getValue()) != null) {
                }
            } else {
                eventScopeInstanceState.triggerStartEvent(key.getValue(), -1L, elementIdBuffer, value.get(), -1L);
            }
            this.temporaryVariableColumnFamily.deleteExisting((DbKey)key);
        });
    }

    @Override
    public void migrateDecisionsPopulateDecisionVersionByDecisionIdAndDecisionKey() {
        this.decisionsByKeyColumnFamily.forEach((key, value) -> {
            this.dbDecisionId.wrapBuffer(value.getDecisionId());
            this.dbDecisionKey.wrapLong(value.getDecisionKey());
            this.dbDecisionVersion.wrapInt(value.getVersion());
            this.decisionKeyByDecisionIdAndVersion.insert(this.decisionKeyAndVersion, this.fkDecision);
        });
    }

    @Override
    public void migrateDrgPopulateDrgVersionByDrgIdAndKey() {
        this.decisionRequirementsByKeyColumnFamily.forEach((key, value) -> {
            this.dbDecisionRequirementsId.wrapBuffer(value.getDecisionRequirementsId());
            this.dbDecisionRequirementsKey.wrapLong(value.getDecisionRequirementsKey());
            this.dbDecisionRequirementsVersion.wrapInt(value.getDecisionRequirementsVersion());
            this.decisionRequirementsKeyByIdAndVersionColumnFamily.insert(this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        });
    }

    @Override
    public void markMigrationFinished(String identifier) {
        this.migrationIdentifier.wrapString(identifier);
        this.migrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)new MigrationTaskState().setState(MIGRATION_TASK_FINISHED_STATE));
    }

    @Override
    public boolean isMigrationFinished(String identifier) {
        this.migrationIdentifier.wrapString(identifier);
        MigrationTaskState migrationState = (MigrationTaskState)this.migrationStateColumnFamily.get((DbKey)this.migrationIdentifier);
        return migrationState != null && migrationState.getState() == MIGRATION_TASK_FINISHED_STATE;
    }
}

