/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.json.mgmt.Token;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class BlacklistsEntity
extends BaseManagementEntity {
    BlacklistsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<List<Token>> getBlacklist(String audience) {
        Asserts.assertNotNull(audience, "audience");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/blacklists/tokens").addQueryParameter("aud", audience).build().toString();
        CustomRequest<List<Token>> request = new CustomRequest<List<Token>>(this.client, url, "GET", new TypeReference<List<Token>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> blacklistToken(Token token) {
        Asserts.assertNotNull(token, "token");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/blacklists/tokens").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "POST");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(token);
        return request;
    }
}

