/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import com.auth0.exception.APIException;
import com.auth0.exception.Auth0Exception;
import com.auth0.exception.RateLimitException;
import com.auth0.net.BaseRequest;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

abstract class ExtendedBaseRequest<T>
extends BaseRequest<T> {
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private final String url;
    private final String method;
    private final ObjectMapper mapper;
    private final Map<String, String> headers;
    private static final int STATUS_CODE_TOO_MANY_REQUEST = 429;

    ExtendedBaseRequest(OkHttpClient client, String url, String method, ObjectMapper mapper) {
        super(client);
        this.url = url;
        this.method = method;
        this.mapper = mapper;
        this.headers = new HashMap<String, String>();
    }

    @Override
    protected Request createRequest() throws Auth0Exception {
        RequestBody body;
        try {
            body = this.createRequestBody();
        }
        catch (IOException e) {
            throw new Auth0Exception("Couldn't create the request body.", e);
        }
        Request.Builder builder = new Request.Builder().url(this.url).method(this.method, body);
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            builder.addHeader(e.getKey(), e.getValue());
        }
        builder.addHeader("Content-Type", this.getContentType());
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected T parseResponse(Response response) throws Auth0Exception {
        if (!response.isSuccessful()) {
            throw this.createResponseException(response);
        }
        try (ResponseBody body = response.body();){
            T t = this.readResponseBody(body);
            return t;
        }
        catch (IOException e) {
            throw new APIException("Failed to parse the response body.", response.code(), e);
        }
    }

    protected String getContentType() {
        return CONTENT_TYPE_APPLICATION_JSON;
    }

    protected abstract RequestBody createRequestBody() throws IOException;

    protected abstract T readResponseBody(ResponseBody var1) throws IOException;

    public ExtendedBaseRequest<T> addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Auth0Exception createResponseException(Response response) {
        if (response.code() == 429) {
            return this.createRateLimitException(response);
        }
        String payload = null;
        try (ResponseBody body = response.body();){
            payload = body.string();
            MapType mapType = this.mapper.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
            Map values = (Map)this.mapper.readValue(payload, (JavaType)mapType);
            APIException aPIException = new APIException(values, response.code());
            return aPIException;
        }
        catch (IOException e) {
            return new APIException(payload, response.code(), e);
        }
    }

    private RateLimitException createRateLimitException(Response response) {
        long limit = Long.parseLong(response.header("X-RateLimit-Limit", "-1"));
        long remaining = Long.parseLong(response.header("X-RateLimit-Remaining", "-1"));
        long reset = Long.parseLong(response.header("X-RateLimit-Reset", "-1"));
        return new RateLimitException(limit, remaining, reset);
    }
}

