/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.SchedulingHints;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;
import io.camunda.zeebe.snapshots.RestorableSnapshotStore;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.camunda.zeebe.snapshots.impl.SnapshotMetrics;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.agrona.collections.Int2ObjectHashMap;

public final class FileBasedSnapshotStoreFactory
implements ReceivableSnapshotStoreFactory {
    public static final String SNAPSHOTS_DIRECTORY = "snapshots";
    public static final String PENDING_DIRECTORY = "pending";
    private final Int2ObjectHashMap<FileBasedSnapshotStore> partitionSnapshotStores = new Int2ObjectHashMap();
    private final ActorSchedulingService actorScheduler;
    private final int nodeId;

    public FileBasedSnapshotStoreFactory(ActorSchedulingService actorScheduler, int nodeId) {
        this.actorScheduler = actorScheduler;
        this.nodeId = nodeId;
    }

    public static RestorableSnapshotStore createRestorableSnapshotStore(Path root, int partitionId, int nodeId) {
        return FileBasedSnapshotStoreFactory.createSnapshotStoreWithoutOpening(root, partitionId, nodeId);
    }

    private static FileBasedSnapshotStore createSnapshotStoreWithoutOpening(Path root, int partitionId, int nodeId) {
        Path snapshotDirectory = root.resolve(SNAPSHOTS_DIRECTORY);
        Path pendingDirectory = root.resolve(PENDING_DIRECTORY);
        try {
            FileUtil.ensureDirectoryExists((Path)snapshotDirectory);
            FileUtil.ensureDirectoryExists((Path)pendingDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create snapshot directories", e);
        }
        return new FileBasedSnapshotStore(partitionId, new SnapshotMetrics(Integer.toString(partitionId)), snapshotDirectory, pendingDirectory);
    }

    @Override
    public ReceivableSnapshotStore createReceivableSnapshotStore(Path root, int partitionId) {
        return (ReceivableSnapshotStore)this.partitionSnapshotStores.computeIfAbsent(partitionId, p -> {
            FileBasedSnapshotStore snapshotStore = FileBasedSnapshotStoreFactory.createSnapshotStoreWithoutOpening(root, partitionId, this.nodeId);
            this.actorScheduler.submitActor((Actor)snapshotStore, SchedulingHints.ioBound()).join();
            return snapshotStore;
        });
    }

    public ConstructableSnapshotStore getConstructableSnapshotStore(int partitionId) {
        return (ConstructableSnapshotStore)this.partitionSnapshotStores.get(partitionId);
    }

    public ReceivableSnapshotStore getReceivableSnapshotStore(int partitionId) {
        return (ReceivableSnapshotStore)this.partitionSnapshotStores.get(partitionId);
    }

    public PersistedSnapshotStore getPersistedSnapshotStore(int partitionId) {
        return (PersistedSnapshotStore)this.partitionSnapshotStores.get(partitionId);
    }

    @Deprecated
    public ConcurrencyControl getSnapshotStoreConcurrencyControl(int partitionId) {
        return (ConcurrencyControl)this.partitionSnapshotStores.get(partitionId);
    }
}

