/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.distribution;

import io.camunda.zeebe.msgpack.MsgpackException;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.ObjectProperty;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class CommandDistributionRecord
extends UnifiedRecordValue
implements CommandDistributionRecordValue {
    private static final Map<ValueType, Supplier<UnifiedRecordValue>> RECORDS_BY_TYPE = new EnumMap<ValueType, Supplier<UnifiedRecordValue>>(ValueType.class);
    private final IntegerProperty partitionIdProperty = new IntegerProperty("partitionId");
    private final EnumProperty<ValueType> valueTypeProperty = new EnumProperty("valueType", ValueType.class);
    private final ObjectProperty<UnifiedRecordValue> commandValueProperty = new ObjectProperty("commandValue", (ObjectValue)new UnifiedRecordValue());
    private final MsgPackWriter recordValueWriter = new MsgPackWriter();
    private final MsgPackReader recordValueReader = new MsgPackReader();

    public CommandDistributionRecord() {
        this.declareProperty((BaseProperty)this.partitionIdProperty).declareProperty(this.valueTypeProperty).declareProperty(this.commandValueProperty);
    }

    public int getPartitionId() {
        return this.partitionIdProperty.getValue();
    }

    public ValueType getValueType() {
        return (ValueType)this.valueTypeProperty.getValue();
    }

    public RecordValue getCommandValue() {
        if (!this.valueTypeProperty.hasValue()) {
            throw new MsgpackException("Expected to read the value type property, but it's not yet set");
        }
        ValueType valueType = this.getValueType();
        Supplier<UnifiedRecordValue> concrecteRecordValueSupplier = RECORDS_BY_TYPE.get(valueType);
        if (concrecteRecordValueSupplier == null) {
            throw new IllegalStateException("Expected to read the record value, but it's type `" + valueType.name() + "` is unknown. Please add it to RecordDistributionRecord.RECORDS_BY_TYPE");
        }
        UnifiedRecordValue concreteRecordValue = concrecteRecordValueSupplier.get();
        UnifiedRecordValue storedRecordValue = (UnifiedRecordValue)this.commandValueProperty.getValue();
        UnsafeBuffer recordValueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = storedRecordValue.getEncodedLength();
        recordValueBuffer.wrap(new byte[encodedLength]);
        storedRecordValue.write(this.recordValueWriter.wrap((MutableDirectBuffer)recordValueBuffer, 0));
        concreteRecordValue.wrap((DirectBuffer)recordValueBuffer);
        return concreteRecordValue;
    }

    public CommandDistributionRecord setValueType(ValueType valueType) {
        this.valueTypeProperty.setValue((Enum)valueType);
        return this;
    }

    public CommandDistributionRecord setPartitionId(int partitionId) {
        this.partitionIdProperty.setValue(partitionId);
        return this;
    }

    public CommandDistributionRecord setRecordValue(UnifiedRecordValue recordValue) {
        UnsafeBuffer valueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = recordValue.getLength();
        valueBuffer.wrap(new byte[encodedLength]);
        recordValue.write((MutableDirectBuffer)valueBuffer, 0);
        ((UnifiedRecordValue)this.commandValueProperty.getValue()).read(this.recordValueReader.wrap((DirectBuffer)valueBuffer, 0, encodedLength));
        return this;
    }

    static {
        RECORDS_BY_TYPE.put(ValueType.DEPLOYMENT, DeploymentRecord::new);
    }
}

