/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class VariableRecord
extends UnifiedRecordValue
implements VariableRecordValue {
    private final StringProperty nameProp = new StringProperty("name");
    private final BinaryProperty valueProp = new BinaryProperty("value");
    private final LongProperty scopeKeyProp = new LongProperty("scopeKey");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey");
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey");
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");

    public VariableRecord() {
        this.declareProperty((BaseProperty)this.nameProp).declareProperty((BaseProperty)this.valueProp).declareProperty((BaseProperty)this.scopeKeyProp).declareProperty((BaseProperty)this.processInstanceKeyProp).declareProperty((BaseProperty)this.processDefinitionKeyProp).declareProperty((BaseProperty)this.bpmnProcessIdProp);
    }

    public String getName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.nameProp.getValue());
    }

    public String getValue() {
        return MsgPackConverter.convertToJson(this.valueProp.getValue());
    }

    public long getScopeKey() {
        return this.scopeKeyProp.getValue();
    }

    public VariableRecord setScopeKey(long scopeKey) {
        this.scopeKeyProp.setValue(scopeKey);
        return this;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public VariableRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public VariableRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public VariableRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
        return this;
    }

    public VariableRecord setValue(DirectBuffer value) {
        this.valueProp.setValue(value);
        return this;
    }

    public VariableRecord setName(DirectBuffer name) {
        this.nameProp.setValue(name);
        return this;
    }

    public VariableRecord setValue(DirectBuffer value, int offset, int length) {
        this.valueProp.setValue(value, offset, length);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getNameBuffer() {
        return this.nameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getValueBuffer() {
        return this.valueProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }
}

