/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.exporter.context.ExporterContext;
import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.stream.ExporterMetrics;
import io.camunda.zeebe.broker.exporter.stream.ExportersState;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.exporter.api.context.ScheduledTask;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.ScheduledTimer;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.jar.ThreadContextUtil;
import java.time.Duration;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.slf4j.Logger;

final class ExporterContainer
implements Controller {
    private static final Logger LOG = Loggers.EXPORTER_LOGGER;
    private static final String SKIP_POSITION_UPDATE_ERROR_MESSAGE = "Failed to update exporter position when skipping filtered record, can be skipped, but may indicate an issue if it occurs often";
    private final ExporterContext context;
    private final Exporter exporter;
    private long position;
    private long lastUnacknowledgedPosition;
    private ExportersState exportersState;
    private ExporterMetrics metrics;
    private ActorControl actor;

    ExporterContainer(ExporterDescriptor descriptor) {
        this.context = new ExporterContext(Loggers.getExporterLogger(descriptor.getId()), descriptor.getConfiguration());
        this.exporter = descriptor.newInstance();
    }

    void initContainer(ActorControl actor, ExporterMetrics metrics, ExportersState state) {
        this.actor = actor;
        this.metrics = metrics;
        this.exportersState = state;
    }

    void initPosition() {
        this.lastUnacknowledgedPosition = this.position = this.exportersState.getPosition(this.getId());
        if (this.position == -1L) {
            this.exportersState.setPosition(this.getId(), -1L);
        }
    }

    void openExporter() {
        LOG.debug("Open exporter with id '{}'", (Object)this.getId());
        ThreadContextUtil.runWithClassLoader(() -> this.exporter.open((Controller)this), (ClassLoader)this.exporter.getClass().getClassLoader());
    }

    public ExporterContext getContext() {
        return this.context;
    }

    public Exporter getExporter() {
        return this.exporter;
    }

    public long getPosition() {
        return this.position;
    }

    long getLastUnacknowledgedPosition() {
        return this.lastUnacknowledgedPosition;
    }

    void updatePositionOnSkipIfUpToDate(long eventPosition) {
        if (this.position >= this.lastUnacknowledgedPosition && this.position < eventPosition) {
            try {
                this.updateExporterState(eventPosition);
            }
            catch (Exception e) {
                LOG.warn(SKIP_POSITION_UPDATE_ERROR_MESSAGE, (Throwable)e);
            }
        }
    }

    private void updateExporterState(long eventPosition) {
        this.updateExporterState(eventPosition, null);
    }

    private void updateExporterState(long eventPosition, byte[] metadata) {
        if (this.position < eventPosition) {
            MutableDirectBuffer metadataBuffer = null;
            if (metadata != null) {
                metadataBuffer = BufferUtil.wrapArray((byte[])metadata);
            }
            this.exportersState.setExporterState(this.getId(), eventPosition, (DirectBuffer)metadataBuffer);
            this.metrics.setLastUpdatedExportedPosition(this.getId(), eventPosition);
            this.position = eventPosition;
        }
    }

    public void updateLastExportedRecordPosition(long position) {
        this.actor.run(() -> this.updateExporterState(position));
    }

    public void updateLastExportedRecordPosition(long position, byte[] metadata) {
        this.actor.run(() -> this.updateExporterState(position, metadata));
    }

    public ScheduledTask scheduleCancellableTask(Duration delay, Runnable task) {
        ScheduledTimer scheduledTimer = this.actor.runDelayed(delay, task);
        return () -> ((ScheduledTimer)scheduledTimer).cancel();
    }

    public Optional<byte[]> readMetadata() {
        return Optional.ofNullable(this.exportersState.getExporterMetadata(this.getId())).filter(metadata -> metadata.capacity() > 0).map(BufferUtil::bufferAsArray);
    }

    public String getId() {
        return this.context.getConfiguration().getId();
    }

    private boolean acceptRecord(RecordMetadata metadata) {
        Context.RecordFilter filter = this.context.getFilter();
        return filter.acceptType(metadata.getRecordType()) && filter.acceptValue(metadata.getValueType());
    }

    void configureExporter() throws Exception {
        LOG.debug("Configure exporter with id '{}'", (Object)this.getId());
        ThreadContextUtil.runCheckedWithClassLoader(() -> this.exporter.configure((Context)this.context), (ClassLoader)this.exporter.getClass().getClassLoader());
    }

    boolean exportRecord(RecordMetadata rawMetadata, TypedRecord typedEvent) {
        try {
            if (this.position < typedEvent.getPosition()) {
                if (this.acceptRecord(rawMetadata)) {
                    this.export((Record<?>)typedEvent);
                } else {
                    this.updatePositionOnSkipIfUpToDate(typedEvent.getPosition());
                }
            }
            return true;
        }
        catch (Exception ex) {
            this.context.getLogger().warn("Error on exporting record with key {}", (Object)typedEvent.getKey(), (Object)ex);
            return false;
        }
    }

    private void export(Record<?> record) {
        ThreadContextUtil.runWithClassLoader(() -> this.exporter.export(record), (ClassLoader)this.exporter.getClass().getClassLoader());
        this.lastUnacknowledgedPosition = record.getPosition();
    }

    public void close() {
        try {
            ThreadContextUtil.runCheckedWithClassLoader(() -> ((Exporter)this.exporter).close(), (ClassLoader)this.exporter.getClass().getClassLoader());
        }
        catch (Exception e) {
            this.context.getLogger().error("Error on close", (Throwable)e);
        }
    }
}

