/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.el.impl;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.el.impl.Loggers;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class StaticExpression
implements Expression,
EvaluationResult {
    private final String expression;
    private ResultType resultType;
    private Object result;

    public StaticExpression(String expression) {
        this.expression = expression;
        try {
            this.treatAsNumber(expression);
        }
        catch (NumberFormatException e) {
            this.treatAsString(expression);
        }
    }

    private void treatAsNumber(String expression) {
        this.result = new BigDecimal(expression);
        this.resultType = ResultType.NUMBER;
    }

    private void treatAsString(String expression) {
        this.result = expression;
        this.resultType = ResultType.STRING;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public Optional<String> getVariableName() {
        return Optional.empty();
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getFailureMessage() {
        return null;
    }

    @Override
    public boolean isFailure() {
        return false;
    }

    @Override
    public ResultType getType() {
        return this.resultType;
    }

    @Override
    public DirectBuffer toBuffer() {
        Loggers.LOGGER.warn("StaticExpression.toBuffer() - not yet implemented");
        return null;
    }

    @Override
    public String getString() {
        return this.getType() == ResultType.STRING ? (String)this.result : null;
    }

    @Override
    public Boolean getBoolean() {
        Loggers.LOGGER.warn("StaticExpression.getBoolean() - not yet implemented");
        return null;
    }

    @Override
    public Number getNumber() {
        return this.getType() == ResultType.NUMBER ? (Number)((Number)this.result) : (Number)null;
    }

    @Override
    public Duration getDuration() {
        return null;
    }

    @Override
    public Period getPeriod() {
        return null;
    }

    @Override
    public ZonedDateTime getDateTime() {
        return null;
    }

    @Override
    public List<DirectBuffer> getList() {
        return null;
    }

    @Override
    public List<String> getListOfStrings() {
        return null;
    }
}

