/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.shared.management.BanInstanceService;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.stereotype.Component;

@Component
@WebEndpoint(id="banning")
public final class BanInstanceEndpoint {
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    final BanInstanceService banInstanceService;

    @Autowired
    public BanInstanceEndpoint(BanInstanceService banInstanceService) {
        this.banInstanceService = banInstanceService;
    }

    @WriteOperation
    public WebEndpointResponse<?> post(@Selector(match=Selector.Match.SINGLE) long processInstanceKey) {
        try {
            LOG.info("Send AdminRequest to ban instance with key {}", (Object)processInstanceKey);
            this.banInstanceService.banInstance(processInstanceKey);
            return new WebEndpointResponse(204);
        }
        catch (CompletionException e) {
            return new WebEndpointResponse((Object)e.getCause(), 500);
        }
        catch (Exception e) {
            return new WebEndpointResponse((Object)e, 500);
        }
    }
}

