/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.authentication;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Authentication;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.identity.sdk.authentication.exception.InvalidClaimException;
import io.camunda.identity.sdk.authentication.exception.InvalidSignatureException;
import io.camunda.identity.sdk.authentication.exception.JsonWebKeyException;
import io.camunda.identity.sdk.authentication.exception.TokenDecodeException;
import io.camunda.identity.sdk.authentication.exception.TokenExpiredException;
import io.camunda.identity.sdk.cache.ClientTokenCache;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import org.ehcache.Cache;

public abstract class AbstractAuthentication
implements Authentication {
    public static final long JWKS_CACHE_SIZE = 5L;
    public static final long JWKS_CACHE_LIFETIME_DAYS = 7L;
    protected final IdentityConfiguration configuration;
    protected final Cache<String, Tokens> tokenCache = new ClientTokenCache().getCache();

    protected AbstractAuthentication(IdentityConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Tokens requestToken(String audience) {
        if (!this.tokenCache.containsKey((Object)audience)) {
            this.tokenCache.put((Object)audience, (Object)this.requestFreshToken(audience));
        }
        return (Tokens)this.tokenCache.get((Object)audience);
    }

    @Override
    public DecodedJWT decodeJWT(String token) {
        try {
            return JWT.decode((String)token);
        }
        catch (JWTDecodeException e) {
            throw new TokenDecodeException(e);
        }
    }

    @Override
    public AccessToken verifyTokenIgnoringAudience(String token) {
        return this.verifyToken(token, null);
    }

    @Override
    public AccessToken verifyToken(String token) {
        return this.verifyToken(token, this.configuration.getAudience());
    }

    protected AccessToken verifyToken(String token, String audience) {
        try {
            DecodedJWT jwt = this.verify(this.decodeJWT(token), audience);
            return new AccessToken(jwt, this.getPermissions(jwt, audience), this.getUserDetails(jwt));
        }
        catch (AlgorithmMismatchException | SignatureVerificationException e) {
            throw new InvalidSignatureException(e);
        }
        catch (com.auth0.jwt.exceptions.TokenExpiredException e) {
            throw new TokenExpiredException(e);
        }
        catch (com.auth0.jwt.exceptions.InvalidClaimException e) {
            throw new InvalidClaimException(e);
        }
    }

    private DecodedJWT verify(DecodedJWT token, String audience) {
        try {
            Jwk jwk = this.jwkProvider().get(token.getKeyId());
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            JWTVerifier tokenVerifier = audience != null ? JWT.require((Algorithm)algorithm).withAudience(new String[]{audience}).build() : JWT.require((Algorithm)algorithm).build();
            return tokenVerifier.verify(token);
        }
        catch (JwkException e) {
            throw new JsonWebKeyException("JWKS error", e);
        }
    }

    private UserDetails getUserDetails(DecodedJWT token) {
        return new UserDetails(token.getSubject(), token.getClaim("email").asString(), token.getClaim("preferred_username").asString(), token.getClaim("name").asString());
    }

    protected abstract List<String> getPermissions(DecodedJWT var1, String var2);

    protected abstract JwkProvider jwkProvider();

    protected abstract Tokens requestFreshToken(String var1);
}

