/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.identity.sdk.impl.rest.exception.RestException;
import io.camunda.identity.sdk.impl.rest.request.Request;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;

public class RestClient {
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final HttpClient client;

    public RestClient() {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build());
    }

    RestClient(HttpClient client) {
        this.client = client;
    }

    public <T> T request(Request<T> request) {
        TypeReference<T> typeReference = request.getTypeReference();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        if (request.getParams().isEmpty()) {
            requestBuilder.uri(URI.create(request.getUrl()));
        } else {
            String params = this.generateParamString(request.getParams());
            requestBuilder.uri(URI.create(request.getUrl().concat("?").concat(params)));
        }
        if (request.getAuthentication() != null) {
            requestBuilder.header("Authorization", "Bearer " + request.getAuthentication());
        }
        if (request.getContentType() != null) {
            requestBuilder.header("Content-Type", request.getContentType().toString());
        }
        if (request.getBody() != null) {
            String body;
            switch (request.getContentType()) {
                case X_WWW_URL_ENCODED: {
                    body = this.urlEncodedBody(request.getBody());
                    break;
                }
                default: {
                    try {
                        body = this.jsonBody(request.getBody());
                        break;
                    }
                    catch (JsonProcessingException e) {
                        throw new RestException("body serialization failed", e);
                    }
                }
            }
            requestBuilder.POST(HttpRequest.BodyPublishers.ofString(body));
        }
        HttpRequest httpRequest = requestBuilder.build();
        HttpResponse<?> response = this.send(httpRequest);
        try {
            if (typeReference.getType() == Void.class) {
                return null;
            }
            return (T)this.mapper.readValue(response.body().toString(), typeReference);
        }
        catch (IOException e) {
            throw new RestException("response can not be mapped to provided type", e);
        }
    }

    private HttpResponse<?> send(HttpRequest request) {
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            if (statusCode < 200 || statusCode > 299) {
                throw new RestException(String.format("request failed with status code '%s' and body '%s'", statusCode, response.body().toString()));
            }
            return response;
        }
        catch (IOException | InterruptedException e) {
            throw new RestException("request failed", e);
        }
    }

    private String jsonBody(Object body) throws JsonProcessingException {
        return this.mapper.writeValueAsString(body);
    }

    private String urlEncodedBody(Object body) {
        Map params = (Map)this.mapper.convertValue(body, Map.class);
        return params.keySet().stream().map(key -> key + "=" + this.urlEncode((String)params.get(key))).collect(Collectors.joining("&"));
    }

    private String generateParamString(Map<String, String> params) {
        return params.entrySet().stream().map(entry -> this.urlEncode((String)entry.getKey()).concat("=").concat(this.urlEncode((String)entry.getValue()))).collect(Collectors.joining("&"));
    }

    private String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }
}

