/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.json.mgmt.guardian.EnrollmentTicket;
import com.auth0.json.mgmt.guardian.Factor;
import com.auth0.json.mgmt.guardian.GuardianTemplates;
import com.auth0.json.mgmt.guardian.SNSFactorProvider;
import com.auth0.json.mgmt.guardian.TwilioFactorProvider;
import com.auth0.net.Request;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class GuardianEntity
extends BaseManagementEntity {
    GuardianEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<EnrollmentTicket> createEnrollmentTicket(EnrollmentTicket enrollmentTicket) {
        Asserts.assertNotNull(enrollmentTicket, "enrollment ticket");
        return this.request("POST", new TypeReference<EnrollmentTicket>(){}, builder -> builder.withPathSegments("api/v2/guardian/enrollments/ticket").withBody(enrollmentTicket));
    }

    public Request<Void> deleteEnrollment(String enrollmentId) {
        Asserts.assertNotNull(enrollmentId, "enrollment id");
        return this.voidRequest("DELETE", builder -> builder.withPathSegments("api/v2/guardian/enrollments").withPathSegments(enrollmentId));
    }

    public Request<GuardianTemplates> getTemplates() {
        return this.request("GET", new TypeReference<GuardianTemplates>(){}, builder -> builder.withPathSegments("api/v2/guardian/factors/sms/templates"));
    }

    public Request<GuardianTemplates> updateTemplates(GuardianTemplates guardianTemplates) {
        Asserts.assertNotNull(guardianTemplates, "guardian templates");
        return this.request("PUT", new TypeReference<GuardianTemplates>(){}, builder -> builder.withPathSegments("api/v2/guardian/factors/sms/templates").withBody(guardianTemplates));
    }

    public Request<List<Factor>> listFactors() {
        return this.request("GET", new TypeReference<List<Factor>>(){}, builder -> builder.withPathSegments("api/v2/guardian/factors"));
    }

    public Request<Factor> updateFactor(String name, Boolean enabled) {
        Asserts.assertNotNull(name, "name");
        Asserts.assertNotNull(enabled, "enabled");
        return this.request("PUT", new TypeReference<Factor>(){}, builder -> builder.withPathSegments("api/v2/guardian/factors").withPathSegments(name).withParameter("enabled", enabled));
    }

    public Request<TwilioFactorProvider> getTwilioFactorProvider() {
        return this.request("GET", new TypeReference<TwilioFactorProvider>(){}, builder -> builder.withPathSegments("api/v2/guardian/factors/sms/providers/twilio"));
    }

    public Request<TwilioFactorProvider> updateTwilioFactorProvider(TwilioFactorProvider provider) {
        Asserts.assertNotNull(provider, "provider");
        return this.request("PUT", new TypeReference<TwilioFactorProvider>(){}, builder -> builder.withPathSegments("api/v2/guardian/factors/sms/providers/twilio").withBody(provider));
    }

    public Request<TwilioFactorProvider> resetTwilioFactorProvider() {
        return this.updateTwilioFactorProvider(new TwilioFactorProvider(null, null, null, null));
    }

    public Request<SNSFactorProvider> getSNSFactorProvider() {
        return this.request("GET", new TypeReference<SNSFactorProvider>(){}, builder -> builder.withPathSegments("api/v2/guardian/factors/push-notification/providers/sns"));
    }

    public Request<SNSFactorProvider> updateSNSFactorProvider(SNSFactorProvider provider) {
        Asserts.assertNotNull(provider, "provider");
        return this.request("PUT", new TypeReference<SNSFactorProvider>(){}, builder -> builder.withPathSegments("api/v2/guardian/factors/push-notification/providers/sns").withBody(provider));
    }

    public Request<SNSFactorProvider> resetSNSFactorProvider() {
        return this.updateSNSFactorProvider(new SNSFactorProvider(null, null, null, null, null));
    }

    public Request<List<String>> getAuthenticationPolicies() {
        return this.request("GET", new TypeReference<List<String>>(){}, builder -> builder.withPathSegments("api/v2/guardian/policies"));
    }

    public Request<List<String>> updateAuthenticationPolicies(List<String> policies) {
        Asserts.assertNotNull(policies, "policies");
        return this.request("PUT", new TypeReference<List<String>>(){}, builder -> builder.withPathSegments("api/v2/guardian/policies").withBody(policies));
    }
}

