/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.json.mgmt.tickets.EmailVerificationTicket;
import com.auth0.json.mgmt.tickets.PasswordChangeTicket;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class TicketsEntity
extends BaseManagementEntity {
    TicketsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<EmailVerificationTicket> requestEmailVerification(EmailVerificationTicket emailVerificationTicket) {
        Asserts.assertNotNull(emailVerificationTicket, "email verification ticket");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/tickets/email-verification").build().toString();
        CustomRequest<EmailVerificationTicket> request = new CustomRequest<EmailVerificationTicket>(this.client, url, "POST", new TypeReference<EmailVerificationTicket>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(emailVerificationTicket);
        return request;
    }

    public Request<PasswordChangeTicket> requestPasswordChange(PasswordChangeTicket passwordChangeTicket) {
        Asserts.assertNotNull(passwordChangeTicket, "password change ticket");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/tickets/password-change").build().toString();
        CustomRequest<PasswordChangeTicket> request = new CustomRequest<PasswordChangeTicket>(this.client, url, "POST", new TypeReference<PasswordChangeTicket>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(passwordChangeTicket);
        return request;
    }
}

