/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import com.auth0.net.ExtendedBaseRequest;
import com.auth0.net.FormDataRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class MultipartRequest<T>
extends ExtendedBaseRequest<T>
implements FormDataRequest<T> {
    private static final String CONTENT_TYPE_FORM_DATA = "multipart/form-data";
    private final MultipartBody.Builder bodyBuilder;
    private final TypeReference<T> tType;
    private final ObjectMapper mapper;
    private int partsCount;

    MultipartRequest(OkHttpClient client, String url, String method, ObjectMapper mapper, TypeReference<T> tType, MultipartBody.Builder multipartBuilder) {
        super(client, url, method, mapper);
        if ("GET".equalsIgnoreCase(method)) {
            throw new IllegalArgumentException("Multipart/form-data requests do not support the GET method.");
        }
        this.mapper = mapper;
        this.tType = tType;
        this.bodyBuilder = multipartBuilder.setType(MultipartBody.FORM);
    }

    public MultipartRequest(OkHttpClient client, String url, String method, TypeReference<T> tType) {
        this(client, url, method, new ObjectMapper(), tType, new MultipartBody.Builder());
    }

    @Override
    protected String getContentType() {
        return CONTENT_TYPE_FORM_DATA;
    }

    @Override
    protected RequestBody createRequestBody() throws IOException {
        if (this.partsCount == 0) {
            throw new IOException("Cannot create multipart/form-data request body with zero parts.");
        }
        return this.bodyBuilder.build();
    }

    @Override
    protected T readResponseBody(ResponseBody body) throws IOException {
        String payload = body.string();
        return (T)this.mapper.readValue(payload, this.tType);
    }

    @Override
    public MultipartRequest<T> addHeader(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    @Override
    public MultipartRequest<T> addPart(String name, File file, String mediaType) {
        Asserts.assertNotNull(name, "name");
        Asserts.assertNotNull(name, "file");
        if (!file.exists()) {
            throw new IllegalArgumentException("Failed to add part because the file specified cannot be found.");
        }
        this.bodyBuilder.addFormDataPart(name, file.getName(), RequestBody.create((MediaType)MediaType.parse((String)mediaType), (File)file));
        ++this.partsCount;
        return this;
    }

    @Override
    public MultipartRequest<T> addPart(String name, String value) {
        Asserts.assertNotNull(name, "name");
        Asserts.assertNotNull(value, "value");
        this.bodyBuilder.addFormDataPart(name, value);
        ++this.partsCount;
        return this;
    }
}

