/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MetaAttribute;
import io.camunda.zeebe.transport.stream.impl.messages.UUIDDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class RemoveStreamRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 401;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 1;
    public static final String SEMANTIC_VERSION = "8.2.23";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RemoveStreamRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final UUIDDecoder id = new UUIDDecoder();

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 401;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RemoveStreamRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public RemoveStreamRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (401 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public RemoveStreamRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int idId() {
        return 1;
    }

    public static int idSinceVersion() {
        return 0;
    }

    public static int idEncodingOffset() {
        return 0;
    }

    public static int idEncodingLength() {
        return 16;
    }

    public static String idMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UUIDDecoder id() {
        this.id.wrap(this.buffer, this.offset + 0);
        return this.id;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RemoveStreamRequestDecoder decoder = new RemoveStreamRequestDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[RemoveStreamRequest](sbeTemplateId=");
        builder.append(401);
        builder.append("|sbeSchemaId=");
        builder.append(0);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 16) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(16);
        builder.append("):");
        builder.append("id=");
        UUIDDecoder id = this.id();
        if (id != null) {
            id.appendTo(builder);
        } else {
            builder.append("null");
        }
        this.limit(originalLimit);
        return builder;
    }

    public RemoveStreamRequestDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

