/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.UUIDDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class UUIDEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 1;
    public static final String SEMANTIC_VERSION = "8.2.23";
    public static final int ENCODED_LENGTH = 16;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public UUIDEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 16;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public static int highEncodingOffset() {
        return 0;
    }

    public static int highEncodingLength() {
        return 8;
    }

    public static long highNullValue() {
        return Long.MIN_VALUE;
    }

    public static long highMinValue() {
        return -9223372036854775807L;
    }

    public static long highMaxValue() {
        return Long.MAX_VALUE;
    }

    public UUIDEncoder high(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int lowEncodingOffset() {
        return 8;
    }

    public static int lowEncodingLength() {
        return 8;
    }

    public static long lowNullValue() {
        return Long.MIN_VALUE;
    }

    public static long lowMinValue() {
        return -9223372036854775807L;
    }

    public static long lowMaxValue() {
        return Long.MAX_VALUE;
    }

    public UUIDEncoder low(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        UUIDDecoder decoder = new UUIDDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

