/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.ExpressionTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.time.ZonedDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BpmnJobBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BpmnJobBehavior.class.getPackageName());
    private static final Set<JobState.State> CANCELABLE_STATES = EnumSet.of(JobState.State.ACTIVATABLE, JobState.State.ACTIVATED, JobState.State.FAILED, JobState.State.ERROR_THROWN);
    private final JobRecord jobRecord = new JobRecord().setVariables(DocumentValue.EMPTY_DOCUMENT);
    private final HeaderEncoder headerEncoder = new HeaderEncoder();
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final JobState jobState;
    private final ExpressionProcessor expressionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final JobMetrics jobMetrics;

    public BpmnJobBehavior(KeyGenerator keyGenerator, JobState jobState, Writers writers, ExpressionProcessor expressionBehavior, BpmnStateBehavior stateBehavior, BpmnIncidentBehavior incidentBehavior, JobMetrics jobMetrics) {
        this.keyGenerator = keyGenerator;
        this.jobState = jobState;
        this.expressionBehavior = expressionBehavior;
        this.stateWriter = writers.state();
        this.stateBehavior = stateBehavior;
        this.incidentBehavior = incidentBehavior;
        this.jobMetrics = jobMetrics;
    }

    public Either<Failure, JobProperties> evaluateJobExpressions(ExecutableJobWorkerElement element, BpmnElementContext context) {
        JobWorkerProperties jobWorkerProps = element.getJobWorkerProperties();
        long scopeKey = context.getElementInstanceKey();
        return Either.right((Object)new JobProperties()).flatMap(p -> this.evalTypeExp(jobWorkerProps, scopeKey).map(p::type)).flatMap(p -> this.evalRetriesExp(jobWorkerProps, scopeKey).map(p::retries)).flatMap(p -> this.evalAssigneeExp(jobWorkerProps, scopeKey).map(p::assignee)).flatMap(p -> this.evalCandidateGroupsExp(jobWorkerProps, scopeKey).map(p::candidateGroups)).flatMap(p -> this.evalCandidateUsersExp(jobWorkerProps, scopeKey).map(p::candidateUsers)).flatMap(p -> this.evalDateExp(jobWorkerProps.getDueDate(), scopeKey).map(p::dueDate)).flatMap(p -> this.evalDateExp(jobWorkerProps.getFollowUpDate(), scopeKey).map(p::followUpDate));
    }

    public void createNewJob(BpmnElementContext context, ExecutableJobWorkerElement element, JobProperties jobProperties) {
        this.writeJobCreatedEvent(context, element, jobProperties);
        this.jobMetrics.jobCreated(jobProperties.getType());
    }

    private Either<Failure, String> evalTypeExp(JobWorkerProperties jobWorkerProperties, long scopeKey) {
        Expression type = jobWorkerProperties.getType();
        return this.expressionBehavior.evaluateStringExpression(type, scopeKey);
    }

    private Either<Failure, Long> evalRetriesExp(JobWorkerProperties jobWorkerProperties, long scopeKey) {
        Expression retries = jobWorkerProperties.getRetries();
        return this.expressionBehavior.evaluateLongExpression(retries, scopeKey);
    }

    private Either<Failure, String> evalAssigneeExp(JobWorkerProperties jobWorkerProperties, long scopeKey) {
        Expression assignee = jobWorkerProperties.getAssignee();
        if (assignee == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateStringExpression(assignee, scopeKey);
    }

    private Either<Failure, String> evalCandidateGroupsExp(JobWorkerProperties jobWorkerProperties, long scopeKey) {
        Expression candidateGroups = jobWorkerProperties.getCandidateGroups();
        if (candidateGroups == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateArrayOfStringsExpression(candidateGroups, scopeKey).map(ExpressionTransformer::asListLiteral);
    }

    private Either<Failure, String> evalCandidateUsersExp(JobWorkerProperties jobWorkerProperties, long scopeKey) {
        Expression candidateUsers = jobWorkerProperties.getCandidateUsers();
        if (candidateUsers == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateArrayOfStringsExpression(candidateUsers, scopeKey).map(ExpressionTransformer::asListLiteral);
    }

    private Either<Failure, String> evalDateExp(Expression date, long scopeKey) {
        if (date == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateDateTimeExpression(date, scopeKey, true).map(optionalDate -> optionalDate.map(ZonedDateTime::toString).orElse(null));
    }

    private void writeJobCreatedEvent(BpmnElementContext context, ExecutableJobWorkerElement jobWorkerElement, JobProperties props) {
        Map<String, String> taskHeaders = jobWorkerElement.getJobWorkerProperties().getTaskHeaders();
        DirectBuffer encodedHeaders = this.encodeHeaders(taskHeaders, props);
        this.jobRecord.setType(props.getType()).setRetries(props.getRetries().intValue()).setCustomHeaders(encodedHeaders).setBpmnProcessId(context.getBpmnProcessId()).setProcessDefinitionVersion(context.getProcessVersion()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementId(jobWorkerElement.getId()).setElementInstanceKey(context.getElementInstanceKey());
        long jobKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.CREATED, (RecordValue)this.jobRecord);
    }

    private DirectBuffer encodeHeaders(Map<String, String> taskHeaders, JobProperties props) {
        HashMap<String, String> headers = new HashMap<String, String>(taskHeaders);
        String assignee = props.getAssignee();
        String candidateGroups = props.getCandidateGroups();
        String candidateUsers = props.getCandidateUsers();
        String dueDate = props.getDueDate();
        String followUpDate = props.getFollowUpDate();
        if (assignee != null && !assignee.isEmpty()) {
            headers.put("io.camunda.zeebe:assignee", assignee);
        }
        if (candidateGroups != null && !candidateGroups.isEmpty()) {
            headers.put("io.camunda.zeebe:candidateGroups", candidateGroups);
        }
        if (candidateUsers != null && !candidateUsers.isEmpty()) {
            headers.put("io.camunda.zeebe:candidateUsers", candidateUsers);
        }
        if (dueDate != null && !dueDate.isEmpty()) {
            headers.put("io.camunda.zeebe:dueDate", dueDate);
        }
        if (followUpDate != null && !followUpDate.isEmpty()) {
            headers.put("io.camunda.zeebe:followUpDate", followUpDate);
        }
        return this.headerEncoder.encode(headers);
    }

    public void cancelJob(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        this.cancelJob(elementInstance);
    }

    public void cancelJob(ElementInstance elementInstance) {
        long jobKey = elementInstance.getJobKey();
        if (jobKey > 0L) {
            this.writeJobCanceled(jobKey);
            this.incidentBehavior.resolveJobIncident(jobKey);
        }
    }

    private void writeJobCanceled(long jobKey) {
        JobState.State state = this.jobState.getState(jobKey);
        if (CANCELABLE_STATES.contains((Object)state)) {
            JobRecord job = this.jobState.getJob(jobKey);
            this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.CANCELED, (RecordValue)job);
            this.jobMetrics.jobCanceled(job.getType());
        }
    }

    private static final class HeaderEncoder {
        private static final int INITIAL_SIZE_KEY_VALUE_PAIR = 128;
        private final MsgPackWriter msgPackWriter = new MsgPackWriter();

        private HeaderEncoder() {
        }

        public DirectBuffer encode(Map<String, String> taskHeaders) {
            if (taskHeaders == null || taskHeaders.isEmpty()) {
                return JobRecord.NO_HEADERS;
            }
            UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
            Map<String, String> validHeaders = taskHeaders.entrySet().stream().filter(entry -> this.isValidHeader((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (validHeaders.size() != taskHeaders.size()) {
                LOGGER.debug("Ignored {} invalid headers.", (Object)(taskHeaders.size() - validHeaders.size()));
            }
            ExpandableArrayBuffer expandableBuffer = new ExpandableArrayBuffer(128 * validHeaders.size());
            this.msgPackWriter.wrap((MutableDirectBuffer)expandableBuffer, 0);
            this.msgPackWriter.writeMapHeader(validHeaders.size());
            validHeaders.forEach((k, v) -> {
                DirectBuffer key = BufferUtil.wrapString((String)k);
                this.msgPackWriter.writeString(key);
                DirectBuffer value = BufferUtil.wrapString((String)v);
                this.msgPackWriter.writeString(value);
            });
            buffer.wrap(expandableBuffer.byteArray(), 0, this.msgPackWriter.getOffset());
            return buffer;
        }

        private boolean isValidHeader(String key, String value) {
            return key != null && !key.isEmpty() && value != null && !value.isEmpty();
        }
    }

    public static final class JobProperties {
        private String type;
        private Long retries;
        private String assignee;
        private String candidateGroups;
        private String candidateUsers;
        private String dueDate;
        private String followUpDate;

        public JobProperties type(String type) {
            this.type = type;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public JobProperties retries(Long retries) {
            this.retries = retries;
            return this;
        }

        public Long getRetries() {
            return this.retries;
        }

        public JobProperties assignee(String assignee) {
            this.assignee = assignee;
            return this;
        }

        public String getAssignee() {
            return this.assignee;
        }

        public JobProperties candidateGroups(String candidateGroups) {
            this.candidateGroups = candidateGroups;
            return this;
        }

        public String getCandidateGroups() {
            return this.candidateGroups;
        }

        public JobProperties candidateUsers(String candidateUsers) {
            this.candidateUsers = candidateUsers;
            return this;
        }

        public String getCandidateUsers() {
            return this.candidateUsers;
        }

        public JobProperties dueDate(String dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public String getDueDate() {
            return this.dueDate;
        }

        public JobProperties followUpDate(String followUpDate) {
            this.followUpDate = followUpDate;
            return this;
        }

        public String getFollowUpDate() {
            return this.followUpDate;
        }
    }
}

