/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.SignalSubscriptionState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.function.Predicate;

public class StartEventSubscriptionManager {
    private final MessageStartEventSubscriptionRecord messageSubscriptionRecord = new MessageStartEventSubscriptionRecord();
    private final SignalSubscriptionRecord signalSubscriptionRecord = new SignalSubscriptionRecord();
    private final ProcessState processState;
    private final MessageStartEventSubscriptionState messageStartEventSubscriptionState;
    private final SignalSubscriptionState signalSubscriptionState;
    private final KeyGenerator keyGenerator;

    public StartEventSubscriptionManager(ProcessingState processingState, KeyGenerator keyGenerator) {
        this.processState = processingState.getProcessState();
        this.messageStartEventSubscriptionState = processingState.getMessageStartEventSubscriptionState();
        this.signalSubscriptionState = processingState.getSignalSubscriptionState();
        this.keyGenerator = keyGenerator;
    }

    public void tryReOpenStartEventSubscription(DeploymentRecord deploymentRecord, StateWriter stateWriter) {
        for (ProcessMetadata processRecord : deploymentRecord.processesMetadata()) {
            if (processRecord.isDuplicate() || !this.isLatestProcess(processRecord)) continue;
            this.closeExistingStartEventSubscriptions(processRecord, stateWriter);
            this.openStartEventSubscriptions(processRecord, stateWriter);
        }
    }

    private boolean isLatestProcess(ProcessMetadata processRecord) {
        return this.processState.getLatestProcessVersionByProcessId(processRecord.getBpmnProcessIdBuffer()).getVersion() == processRecord.getVersion();
    }

    private void closeExistingStartEventSubscriptions(ProcessMetadata processRecord, StateWriter stateWriter) {
        this.closeMessageExistingStartEventSubscriptions(processRecord, stateWriter);
        this.closeSignalExistingStartEventSubscriptions(processRecord, stateWriter);
    }

    private void closeMessageExistingStartEventSubscriptions(ProcessMetadata processRecord, StateWriter stateWriter) {
        DeployedProcess lastMsgProcess = this.findLastStartProcess(processRecord, ExecutableCatchEventElement::isMessage);
        if (lastMsgProcess == null) {
            return;
        }
        this.messageStartEventSubscriptionState.visitSubscriptionsByProcessDefinition(lastMsgProcess.getKey(), subscription -> stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)MessageStartEventSubscriptionIntent.DELETED, (RecordValue)subscription.getRecord()));
    }

    private void closeSignalExistingStartEventSubscriptions(ProcessMetadata processRecord, StateWriter stateWriter) {
        DeployedProcess lastSignalProcess = this.findLastStartProcess(processRecord, ExecutableCatchEventElement::isSignal);
        if (lastSignalProcess == null) {
            return;
        }
        this.signalSubscriptionState.visitStartEventSubscriptionsByProcessDefinitionKey(lastSignalProcess.getKey(), subscription -> stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)SignalSubscriptionIntent.DELETED, (RecordValue)subscription.getRecord()));
    }

    private DeployedProcess findLastStartProcess(ProcessMetadata processRecord, Predicate<ExecutableCatchEventElement> hasStartEventMatching) {
        for (int version = processRecord.getVersion() - 1; version > 0; --version) {
            DeployedProcess lastStartProcess = this.processState.getProcessByProcessIdAndVersion(processRecord.getBpmnProcessIdBuffer(), version);
            if (lastStartProcess == null || !lastStartProcess.getProcess().getStartEvents().stream().anyMatch(hasStartEventMatching)) continue;
            return lastStartProcess;
        }
        return null;
    }

    private void openStartEventSubscriptions(ProcessMetadata processRecord, StateWriter stateWriter) {
        long processDefinitionKey = processRecord.getKey();
        DeployedProcess processDefinition = this.processState.getProcessByKey(processDefinitionKey);
        ExecutableProcess process = processDefinition.getProcess();
        List<ExecutableStartEvent> startEvents = process.getStartEvents();
        for (ExecutableStartEvent startEvent : startEvents) {
            if (startEvent.isMessage()) {
                this.openMessageStartEventSubscription(processDefinition, processDefinitionKey, startEvent, stateWriter);
                continue;
            }
            if (!startEvent.isSignal()) continue;
            this.openSignalStartEventSubscription(processDefinition, processDefinitionKey, startEvent, stateWriter);
        }
    }

    private void openMessageStartEventSubscription(DeployedProcess processDefinition, long processDefinitionKey, ExecutableStartEvent startEvent, StateWriter stateWriter) {
        ExecutableMessage message = startEvent.getMessage();
        message.getMessageName().map(BufferUtil::wrapString).ifPresent(messageNameBuffer -> {
            this.messageSubscriptionRecord.reset();
            this.messageSubscriptionRecord.setMessageName(messageNameBuffer).setProcessDefinitionKey(processDefinitionKey).setBpmnProcessId(processDefinition.getBpmnProcessId()).setStartEventId(startEvent.getId());
            long subscriptionKey = this.keyGenerator.nextKey();
            stateWriter.appendFollowUpEvent(subscriptionKey, (Intent)MessageStartEventSubscriptionIntent.CREATED, (RecordValue)this.messageSubscriptionRecord);
        });
    }

    private void openSignalStartEventSubscription(DeployedProcess processDefinition, long processDefinitionKey, ExecutableStartEvent startEvent, StateWriter stateWriter) {
        ExecutableSignal signal = startEvent.getSignal();
        signal.getSignalName().map(BufferUtil::wrapString).ifPresent(signalNameBuffer -> {
            this.signalSubscriptionRecord.reset();
            this.signalSubscriptionRecord.setSignalName(signalNameBuffer).setProcessDefinitionKey(processDefinitionKey).setBpmnProcessId(processDefinition.getBpmnProcessId()).setCatchEventId(startEvent.getId());
            long subscriptionKey = this.keyGenerator.nextKey();
            stateWriter.appendFollowUpEvent(subscriptionKey, (Intent)SignalSubscriptionIntent.CREATED, (RecordValue)this.signalSubscriptionRecord);
        });
    }
}

