/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceBatchIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;

public final class ProcessInstanceBatchActivateProcessor
implements TypedRecordProcessor<ProcessInstanceBatchRecord> {
    private final TypedCommandWriter commandWriter;
    private final KeyGenerator keyGenerator;
    private final ElementInstanceState elementInstanceState;
    private final ProcessState processState;

    public ProcessInstanceBatchActivateProcessor(Writers writers, KeyGenerator keyGenerator, ElementInstanceState elementInstanceState, ProcessState processState) {
        this.commandWriter = writers.command();
        this.keyGenerator = keyGenerator;
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceBatchRecord> record) {
        ProcessInstanceBatchRecord recordValue = (ProcessInstanceBatchRecord)record.getValue();
        ProcessInstanceRecord childInstanceRecord = this.createChildInstanceRecord(recordValue);
        for (long amountOfChildInstancesToActivate = recordValue.getIndex(); amountOfChildInstancesToActivate > 0L; --amountOfChildInstancesToActivate) {
            if (this.canWriteCommands(record, childInstanceRecord)) {
                long childInstanceKey = this.keyGenerator.nextKey();
                this.commandWriter.appendFollowUpCommand(childInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)childInstanceRecord);
                continue;
            }
            this.writeFollowupBatchCommand(recordValue, amountOfChildInstancesToActivate);
            break;
        }
    }

    private ProcessInstanceRecord createChildInstanceRecord(ProcessInstanceBatchRecord recordValue) {
        ElementInstance parentElementInstance = this.elementInstanceState.getInstance(recordValue.getBatchElementInstanceKey());
        ExecutableProcess processDefinition = this.processState.getProcessByKey(parentElementInstance.getValue().getProcessDefinitionKey()).getProcess();
        AbstractFlowElement parentElement = processDefinition.getElementById(parentElementInstance.getValue().getElementId());
        ExecutableActivity childElement = ((ExecutableMultiInstanceBody)parentElement).getInnerActivity();
        ProcessInstanceRecord childInstanceRecord = new ProcessInstanceRecord();
        childInstanceRecord.wrap(parentElementInstance.getValue());
        childInstanceRecord.setFlowScopeKey(parentElementInstance.getKey()).setElementId(childElement.getId()).setBpmnElementType(childElement.getElementType()).setBpmnEventType(childElement.getEventType());
        return childInstanceRecord;
    }

    private void writeFollowupBatchCommand(ProcessInstanceBatchRecord recordValue, long index) {
        ProcessInstanceBatchRecord nextBatchRecord = new ProcessInstanceBatchRecord().setProcessInstanceKey(recordValue.getProcessInstanceKey()).setBatchElementInstanceKey(recordValue.getBatchElementInstanceKey()).setIndex(index);
        long key = this.keyGenerator.nextKey();
        this.commandWriter.appendFollowUpCommand(key, (Intent)ProcessInstanceBatchIntent.ACTIVATE, (RecordValue)nextBatchRecord);
    }

    private boolean canWriteCommands(TypedRecord<ProcessInstanceBatchRecord> record, ProcessInstanceRecord childInstanceRecord) {
        int expectedCommandLength = record.getLength() + childInstanceRecord.getLength() + 8192;
        return this.commandWriter.canWriteCommandOfLength(expectedCommandLength);
    }
}

