/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.resource;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.immutable.DecisionState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.protocol.impl.record.value.resource.ResourceDeletionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class ResourceDeletionDeleteProcessor
implements TypedRecordProcessor<ResourceDeletionRecord> {
    public static final boolean RESOURCE_DELETION_IMPLEMENTED = false;
    private static final String ERROR_MESSAGE_NOT_IMPLEMENTED = "Resource deletion has not been fully implemented yet. Stay posted on the latest Camunda releases to know when this feature will become available.";
    private static final String ERROR_MESSAGE_RESOURCE_NOT_FOUND = "Expected to delete resource but no resource found with key `%d`";
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final KeyGenerator keyGenerator;
    private final DecisionState decisionState;

    public ResourceDeletionDeleteProcessor(Writers writers, KeyGenerator keyGenerator, DecisionState decisionState) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
        this.keyGenerator = keyGenerator;
        this.decisionState = decisionState;
    }

    @Override
    public void processRecord(TypedRecord<ResourceDeletionRecord> command) {
        this.rejectionWriter.appendRejection(command, RejectionType.PROCESSING_ERROR, ERROR_MESSAGE_NOT_IMPLEMENTED);
        this.responseWriter.writeRejectionOnCommand(command, RejectionType.PROCESSING_ERROR, ERROR_MESSAGE_NOT_IMPLEMENTED);
    }

    private void deleteDecisionRequirements(DeployedDrg drg) {
        this.decisionState.findDecisionsByDecisionRequirementsKey(drg.getDecisionRequirementsKey()).forEach(this::deleteDecision);
        DecisionRequirementsRecord drgRecord = new DecisionRequirementsRecord().setDecisionRequirementsId(BufferUtil.bufferAsString((DirectBuffer)drg.getDecisionRequirementsId())).setDecisionRequirementsName(BufferUtil.bufferAsString((DirectBuffer)drg.getDecisionRequirementsName())).setDecisionRequirementsVersion(drg.getDecisionRequirementsVersion()).setDecisionRequirementsKey(drg.getDecisionRequirementsKey()).setResourceName(BufferUtil.bufferAsString((DirectBuffer)drg.getResourceName())).setChecksum(drg.getChecksum()).setResource(drg.getResource());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)DecisionRequirementsIntent.DELETED, (RecordValue)drgRecord);
    }

    private void deleteDecision(PersistedDecision persistedDecision) {
        DecisionRecord decisionRecord = new DecisionRecord().setDecisionId(BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionId())).setDecisionName(BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionName())).setVersion(persistedDecision.getVersion()).setDecisionKey(persistedDecision.getDecisionKey()).setDecisionRequirementsId(BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionRequirementsId())).setDecisionRequirementsKey(persistedDecision.getDecisionRequirementsKey());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)DecisionIntent.DELETED, (RecordValue)decisionRecord);
    }
}

