/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.signal;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.SignalSubscriptionState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import org.agrona.DirectBuffer;

public class SignalBroadcastProcessor
implements TypedRecordProcessor<SignalRecord> {
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;
    private final EventHandle eventHandle;
    private final TypedResponseWriter responseWriter;
    private final SignalSubscriptionState signalSubscriptionState;

    public SignalBroadcastProcessor(Writers writers, KeyGenerator keyGenerator, EventScopeInstanceState eventScopeInstanceState, ProcessState processState, BpmnStateBehavior stateBehavior, EventTriggerBehavior eventTriggerBehavior, SignalSubscriptionState signalSubscriptionState) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.signalSubscriptionState = signalSubscriptionState;
        this.keyGenerator = keyGenerator;
        this.eventHandle = new EventHandle(keyGenerator, eventScopeInstanceState, writers, processState, eventTriggerBehavior, stateBehavior);
    }

    @Override
    public void processRecord(TypedRecord<SignalRecord> command) {
        SignalRecord signalRecord = (SignalRecord)command.getValue();
        long key = command.getKey();
        DirectBuffer signalName = signalRecord.getSignalNameBuffer();
        long eventKey = key > -1L ? key : this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(eventKey, (Intent)SignalIntent.BROADCASTED, (RecordValue)signalRecord);
        this.responseWriter.writeEventOnCommand(eventKey, (Intent)SignalIntent.BROADCASTED, (UnpackedObject)signalRecord, command);
        this.signalSubscriptionState.visitBySignalName(signalName, subscription -> {
            SignalSubscriptionRecord subscriptionRecord = subscription.getRecord();
            long processDefinitionKey = subscriptionRecord.getProcessDefinitionKey();
            if (subscriptionRecord.getCatchEventInstanceKey() == -1L) {
                this.eventHandle.activateProcessInstanceForStartEvent(processDefinitionKey, this.keyGenerator.nextKey(), subscriptionRecord.getCatchEventIdBuffer(), signalRecord.getVariablesBuffer());
            }
        });
    }
}

